/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.mongodb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.memory.IRegistryHandler;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.registry.mongodb.MongoDBRegistryHandler;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedAASDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedSubmodelDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.map.MapTaggedDirectory;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;

public class MongoDBTaggedDirectory
extends MapTaggedDirectory {
    public MongoDBTaggedDirectory(BaSyxMongoDBConfiguration mongoDBConfig, Map<String, Set<TaggedAASDescriptor>> tagMap) {
        super((IRegistryHandler)new MongoDBRegistryHandler(mongoDBConfig), tagMap);
        this.initializeTagMap();
    }

    public MongoDBTaggedDirectory(BaSyxMongoDBConfiguration mongoDBConfig) {
        this(mongoDBConfig, new HashMap<String, Set<TaggedAASDescriptor>>());
    }

    private void initializeTagMap() {
        List shellDescriptors = this.handler.getAll();
        shellDescriptors.stream().filter(this::isTaggedDescriptor).map(TaggedAASDescriptor::createAsFacade).forEach(x$0 -> super.addTags(x$0));
    }

    private boolean isTaggedDescriptor(ModelDescriptor descriptor) {
        return descriptor.get((Object)"tags") != null;
    }

    public void registerSubmodel(IIdentifier aas, TaggedSubmodelDescriptor descriptor) {
        super.register(aas, (SubmodelDescriptor)descriptor);
        this.addSubmodelTags(descriptor);
        this.updateTagMap(aas, descriptor);
    }

    private void updateTagMap(IIdentifier aas, TaggedSubmodelDescriptor descriptor) {
        this.tagMap.values().forEach(tagSet -> tagSet.forEach(tagDesc -> {
            if (this.descriptorEqualsToGivenAASId(aas, (TaggedAASDescriptor)tagDesc) && !this.containsSubmodelDescriptor(descriptor, (TaggedAASDescriptor)tagDesc)) {
                tagDesc.addSubmodelDescriptor((SubmodelDescriptor)descriptor);
            }
        }));
    }

    private boolean containsSubmodelDescriptor(TaggedSubmodelDescriptor descriptor, TaggedAASDescriptor tagDesc) {
        return tagDesc.getSubmodelDescriptorFromIdShort(descriptor.getIdShort()) != null;
    }

    private boolean descriptorEqualsToGivenAASId(IIdentifier aas, TaggedAASDescriptor tagDesc) {
        return tagDesc.getIdentifier().getId().equals(aas.getId());
    }
}

