/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

public class AtomicDouble
extends Number
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final AtomicLongFieldUpdater<AtomicDouble> UPDATER = AtomicLongFieldUpdater.newUpdater(AtomicDouble.class, "value");
    private volatile transient long value;

    public AtomicDouble(double initialValue) {
        this.value = Double.doubleToRawLongBits(initialValue);
    }

    public AtomicDouble() {
    }

    public final double get() {
        return Double.longBitsToDouble(this.value);
    }

    public final void set(double newValue) {
        long next;
        this.value = next = Double.doubleToRawLongBits(newValue);
    }

    public final void lazySet(double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        UPDATER.lazySet(this, next);
    }

    public final double getAndSet(double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(UPDATER.getAndSet(this, next));
    }

    public final boolean compareAndSet(double expect, double update) {
        return UPDATER.compareAndSet(this, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public final boolean weakCompareAndSet(double expect, double update) {
        return UPDATER.weakCompareAndSet(this, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public final double getAndAdd(double delta) {
        return this.getAndAccumulate(delta, Double::sum);
    }

    public final double addAndGet(double delta) {
        return this.accumulateAndGet(delta, Double::sum);
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public final double getAndAccumulate(double x, DoubleBinaryOperator accumulatorFunction) {
        AtomicDouble.checkNotNull(accumulatorFunction);
        return this.getAndUpdate(oldValue -> accumulatorFunction.applyAsDouble(oldValue, x));
    }

    public final double accumulateAndGet(double x, DoubleBinaryOperator accumulatorFunction) {
        AtomicDouble.checkNotNull(accumulatorFunction);
        return this.updateAndGet(oldValue -> accumulatorFunction.applyAsDouble(oldValue, x));
    }

    public final double getAndUpdate(DoubleUnaryOperator updateFunction) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!UPDATER.compareAndSet(this, current = this.value, next = Double.doubleToRawLongBits(nextVal = updateFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current))))) {
        }
        return currentVal;
    }

    public final double updateAndGet(DoubleUnaryOperator updateFunction) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!UPDATER.compareAndSet(this, current = this.value, next = Double.doubleToRawLongBits(nextVal = updateFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current))))) {
        }
        return nextVal;
    }

    public String toString() {
        return Double.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeDouble(this.get());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.set(stream.readDouble());
    }
}

