/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy;

import java.util.Base64;
import java.util.Map;

public class K8SRequest {
    private byte[] requestByte;
    private String method;
    private String path;
    private String protocol;
    private byte[] payload;
    private Map<String, String[]> headers;

    public byte[] getRequestByte() {
        return this.requestByte;
    }

    public void setRequestByte(byte[] requestByte) {
        this.requestByte = requestByte;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public Map<String, String[]> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String[]> headers) {
        this.headers = headers;
    }

    public String convertToBase64String() {
        String requestBase64String = Base64.getEncoder().encodeToString(this.requestByte);
        return requestBase64String;
    }

    public byte[] convertBase64StringToByte(String requestBase64String) {
        byte[] newRequestByte = Base64.getDecoder().decode(requestBase64String);
        return newRequestByte;
    }

    public String convertToBase64StringWithID() {
        Object requestID = "requestID:" + this.getPathNoParameter() + System.nanoTime() + "\r\n";
        requestID = Base64.getEncoder().encodeToString(((String)requestID).getBytes());
        String requestBase64String = Base64.getEncoder().encodeToString(this.requestByte);
        return (String)requestID + "*" + requestBase64String;
    }

    public String convertBase64StringToString(String requestBase64String) {
        String textString = new String(Base64.getDecoder().decode(requestBase64String));
        return textString;
    }

    public String convertByteArrayToBase64String(byte[] byteArray) {
        String byteArrayBase64String = Base64.getEncoder().encodeToString(byteArray);
        return byteArrayBase64String;
    }

    public String getPathNoParameter() {
        if (this.path.indexOf("?") == -1) {
            return this.path.replace("/", "");
        }
        return (this.path.contains("&watch=true") ? "Watch" : "") + this.path.substring(0, this.path.indexOf("?")).replace("/", "");
    }
}

