/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.GenericStoreUpgrader;
import org.apache.qpid.server.store.StoreUpgraderPhase;
import org.apache.qpid.server.util.Action;

abstract class AbstractConfigurationStoreUpgraderAndRecoverer {
    private final Map<String, StoreUpgraderPhase> _upgraders = new HashMap<String, StoreUpgraderPhase>();
    private final String _initialVersion;

    AbstractConfigurationStoreUpgraderAndRecoverer(String initialVersion) {
        this._initialVersion = initialVersion;
    }

    List<ConfiguredObjectRecord> upgrade(DurableConfigurationStore store, List<ConfiguredObjectRecord> records, String rootCategory, String modelVersionAttributeName) {
        GenericStoreUpgrader upgrader = new GenericStoreUpgrader(rootCategory, modelVersionAttributeName, store, this._upgraders);
        upgrader.upgrade(records);
        return upgrader.getRecords();
    }

    void register(StoreUpgraderPhase upgrader) {
        String fromVersion = upgrader.getFromVersion();
        String toVersion = upgrader.getToVersion();
        if (this._upgraders.containsKey(fromVersion)) {
            throw new IllegalStateException(String.format("Error in store upgrader chain. More than on upgrader from version %s", fromVersion));
        }
        if (fromVersion.equals(toVersion)) {
            throw new IllegalStateException(String.format("Error in store upgrader chain. From version %s cannot be equal to toVersion %s", fromVersion, toVersion));
        }
        if (!fromVersion.equals(this._initialVersion)) {
            boolean found = false;
            for (StoreUpgraderPhase storeUpgraderPhase : this._upgraders.values()) {
                if (!storeUpgraderPhase.getToVersion().equals(fromVersion)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalStateException(String.format("Error in store upgrader chain.No previously defined upgrader to version %s found when registering upgrader from %s to %s", fromVersion, fromVersion, toVersion));
            }
        }
        this._upgraders.put(fromVersion, upgrader);
    }

    void applyRecursively(ConfiguredObject<?> object, RecursiveAction<ConfiguredObject<?>> action) {
        this.applyRecursively(object, action, new HashSet());
    }

    private void applyRecursively(ConfiguredObject<?> object, RecursiveAction<ConfiguredObject<?>> action, HashSet<ConfiguredObject<?>> visited) {
        if (!visited.contains(object)) {
            visited.add(object);
            action.performAction(object);
            if (action.applyToChildren(object)) {
                for (Class<? extends ConfiguredObject> childClass : object.getModel().getChildTypes(object.getCategoryClass())) {
                    Collection<? extends ConfiguredObject> children = object.getChildren(childClass);
                    if (children == null) continue;
                    for (ConfiguredObject configuredObject : children) {
                        this.applyRecursively(configuredObject, action, visited);
                    }
                }
            }
        }
    }

    static interface RecursiveAction<C>
    extends Action<C> {
        public boolean applyToChildren(C var1);
    }
}

