/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v6_1.category;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.management.plugin.ManagementController;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.ManagementResponse;
import org.apache.qpid.server.management.plugin.ResponseType;
import org.apache.qpid.server.management.plugin.controller.CategoryController;
import org.apache.qpid.server.management.plugin.controller.ControllerManagementResponse;
import org.apache.qpid.server.management.plugin.controller.GenericLegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.State;

public class BindingController
implements CategoryController {
    public static final String TYPE = "Binding";
    private final LegacyManagementController _managementController;
    private final ManagementController _nextVersionManagementController;

    BindingController(LegacyManagementController managementController) {
        this._managementController = managementController;
        this._nextVersionManagementController = this._managementController.getNextVersionManagementController();
    }

    @Override
    public String getCategory() {
        return TYPE;
    }

    @Override
    public String getNextVersionCategory() {
        return null;
    }

    @Override
    public String getDefaultType() {
        return null;
    }

    @Override
    public String[] getParentCategories() {
        return new String[]{"Exchange", "Queue"};
    }

    @Override
    public LegacyManagementController getManagementController() {
        return this._managementController;
    }

    @Override
    public Object get(ConfiguredObject<?> root, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        Collection<String> hierarchy = this._managementController.getCategoryHierarchy(root, this.getCategory());
        String bindingName = path.size() == hierarchy.size() ? path.get(hierarchy.size() - 1) : null;
        String queueName = path.size() >= hierarchy.size() - 1 ? path.get(hierarchy.size() - 2) : null;
        List<String> exchangePath = path.size() >= hierarchy.size() - 2 ? path.subList(0, hierarchy.size() - 2) : path;
        return this.getExchangeBindings(root, exchangePath, queueName, bindingName);
    }

    @Override
    public LegacyConfiguredObject createOrUpdate(ConfiguredObject<?> root, List<String> path, Map<String, Object> attributes, boolean isPost) throws ManagementException {
        if (path.contains("*")) {
            throw ManagementException.createBadRequestManagementException("Wildcards in path are not supported for post and put requests");
        }
        Collection<String> hierarchy = this._managementController.getCategoryHierarchy(root, this.getCategory());
        if (path.size() < hierarchy.size() - 2) {
            throw ManagementException.createBadRequestManagementException(String.format("Cannot create binding for path %s", String.join((CharSequence)("/" + path), new CharSequence[0])));
        }
        String queueName = null;
        if (path.size() > hierarchy.size() - 2) {
            queueName = path.get(hierarchy.size() - 2);
        }
        if (queueName == null) {
            queueName = (String)attributes.get("queue");
        }
        if (queueName == null) {
            throw ManagementException.createBadRequestManagementException("Queue is required for binding creation. Please specify queue either in path or in binding attributes");
        }
        List<String> exchangePath = path.subList(0, hierarchy.size() - 2);
        LegacyConfiguredObject nextVersionExchange = this.getNextVersionObject(root, exchangePath, "Exchange");
        ArrayList<String> queuePath = new ArrayList<String>(path.subList(0, hierarchy.size() - 3));
        queuePath.add(queueName);
        LegacyConfiguredObject nextVersionQueue = this.getNextVersionObject(root, queuePath, "Queue");
        String bindingKey = (String)attributes.get("name");
        if (bindingKey == null) {
            String string = bindingKey = path.size() == hierarchy.size() ? path.get(hierarchy.size() - 1) : null;
        }
        if (bindingKey == null) {
            bindingKey = "";
        }
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("bindingKey", bindingKey);
        parameters.put("destination", queueName);
        HashMap<String, Object> arguments = null;
        if (attributes.containsKey("arguments")) {
            Object args = attributes.get("arguments");
            if (args instanceof Map) {
                Map argumentsMap = (Map)args;
                arguments = new HashMap<String, Object>(argumentsMap);
                if (!arguments.isEmpty()) {
                    parameters.put("arguments", arguments);
                }
            } else {
                throw ManagementException.createBadRequestManagementException(String.format("Unexpected attributes specified : %s", args));
            }
        }
        parameters.put("replaceExistingArguments", !isPost);
        ManagementResponse response = nextVersionExchange.invoke("bind", parameters, true);
        boolean newBindings = Boolean.TRUE.equals(response.getBody());
        if (!newBindings) {
            return null;
        }
        return new LegacyBinding(this._managementController, nextVersionExchange, nextVersionQueue, bindingKey, arguments);
    }

    @Override
    public int delete(ConfiguredObject<?> root, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        if (path.contains("*")) {
            throw ManagementException.createBadRequestManagementException("Wildcards in path are not supported for delete requests");
        }
        Collection<String> hierarchy = this._managementController.getCategoryHierarchy(root, this.getCategory());
        if (path.size() < hierarchy.size() - 2) {
            throw ManagementException.createBadRequestManagementException(String.format("Cannot delete binding for path %s", String.join((CharSequence)"/", path)));
        }
        String bindingName = path.size() == hierarchy.size() ? path.get(hierarchy.size() - 1) : null;
        String queueName = path.get(hierarchy.size() - 2);
        List<String> ids = parameters.get("id");
        List<String> exchangePath = path.subList(0, hierarchy.size() - 2);
        LegacyConfiguredObject exchange = this.getNextVersionObject(root, exchangePath, "Exchange");
        AtomicInteger counter = new AtomicInteger();
        if (ids != null && !ids.isEmpty()) {
            Collection bindings = (Collection)exchange.getAttribute("bindings");
            if (bindings != null) {
                bindings.stream().filter(b -> ids.contains(String.valueOf(BindingController.generateBindingId(exchange, b.getDestination(), b.getBindingKey())))).forEach(b -> {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("bindingKey", b.getBindingKey());
                    params.put("destination", b.getDestination());
                    ManagementResponse r = exchange.invoke("unbind", params, true);
                    if (Boolean.TRUE.equals(r.getBody())) {
                        counter.incrementAndGet();
                    }
                });
            }
        } else if (bindingName != null) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("bindingKey", bindingName);
            params.put("destination", queueName);
            ManagementResponse response = exchange.invoke("unbind", params, true);
            if (Boolean.TRUE.equals(response.getBody())) {
                counter.incrementAndGet();
            }
        } else {
            throw ManagementException.createBadRequestManagementException("Only deletion by binding full path or ids is supported");
        }
        return counter.get();
    }

    private LegacyConfiguredObject getNextVersionObject(ConfiguredObject<?> root, List<String> path, String type) {
        return (LegacyConfiguredObject)this._nextVersionManagementController.get(root, type.toLowerCase(), path, Collections.emptyMap());
    }

    @Override
    public ManagementResponse invoke(ConfiguredObject<?> root, List<String> path, String operation, Map<String, Object> parameters, boolean isPost, boolean isSecure) throws ManagementException {
        Object result = this.get(root, path, Collections.emptyMap());
        if (result instanceof Collection && ((Collection)result).size() == 1) {
            LegacyConfiguredObject object = (LegacyConfiguredObject)((Collection)result).iterator().next();
            return object.invoke(operation, parameters, isSecure);
        }
        throw ManagementException.createBadRequestManagementException(String.format("Operation '%s' cannot be invoked for Binding path '%s'", operation, String.join((CharSequence)"/", path)));
    }

    @Override
    public Object getPreferences(ConfiguredObject<?> root, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        throw ManagementException.createBadRequestManagementException("Preferences not supported for Binding");
    }

    @Override
    public void setPreferences(ConfiguredObject<?> root, List<String> path, Object preferences, Map<String, List<String>> parameters, boolean isPost) throws ManagementException {
        throw ManagementException.createBadRequestManagementException("Preferences not supported for Binding");
    }

    @Override
    public int deletePreferences(ConfiguredObject<?> root, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        throw ManagementException.createBadRequestManagementException("Preferences not supported for Binding");
    }

    @Override
    public LegacyConfiguredObject convertFromNextVersion(LegacyConfiguredObject nextVersionObject) {
        return null;
    }

    private Collection<LegacyConfiguredObject> getExchangeBindings(ConfiguredObject<?> root, List<String> exchangePath, String queueName, String bindingName) {
        Object result = this.getNextVersionExchanges(root, exchangePath);
        if (result instanceof LegacyConfiguredObject) {
            return this.getExchangeBindings((LegacyConfiguredObject)result, queueName, bindingName);
        }
        if (result instanceof Collection) {
            return ((Collection)result).stream().map(LegacyConfiguredObject.class::cast).map(e -> this.getExchangeBindings((LegacyConfiguredObject)e, queueName, bindingName)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        throw ManagementException.createInternalServerErrorManagementException("Unexpected format of content from next version");
    }

    private Object getNextVersionExchanges(ConfiguredObject<?> root, List<String> exchangePath) {
        try {
            return this._nextVersionManagementController.get(root, "Exchange".toLowerCase(), exchangePath, Collections.emptyMap());
        }
        catch (ManagementException e) {
            if (e.getStatusCode() != 404) {
                throw e;
            }
            return Collections.emptyList();
        }
    }

    private Collection<LegacyConfiguredObject> getExchangeBindings(LegacyConfiguredObject nextVersionExchange, String queueName, String bindingName) {
        Object items = nextVersionExchange.getAttribute("bindings");
        if (items instanceof Collection) {
            return ((Collection)items).stream().map(Binding.class::cast).filter(b -> !(queueName != null && !"*".equals(queueName) && !queueName.equals(b.getDestination()) || bindingName != null && !"*".equals(bindingName) && !bindingName.equals(b.getName()))).map(b -> this.createManageableBinding((Binding)b, nextVersionExchange)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private LegacyConfiguredObject createManageableBinding(Binding binding, LegacyConfiguredObject nextVersionExchange) {
        LegacyConfiguredObject nextVersionVirtualHost = nextVersionExchange.getParent("VirtualHost");
        LegacyConfiguredObject queue = BindingController.findNextVersionQueue(binding.getDestination(), nextVersionVirtualHost);
        return new LegacyBinding(this._managementController, nextVersionExchange, queue, binding.getBindingKey(), binding.getArguments());
    }

    private static LegacyConfiguredObject findNextVersionQueue(String queueName, LegacyConfiguredObject nextVersionVirtualHost) {
        Collection<LegacyConfiguredObject> queues = nextVersionVirtualHost.getChildren("Queue");
        return queues.stream().filter(q -> queueName.equals(q.getAttribute("name"))).findFirst().orElse(null);
    }

    private static UUID generateBindingId(LegacyConfiguredObject exchange, String queueName, String bindingKey) {
        String pseudoID = exchange.getAttribute("id") + "/" + queueName + "/" + bindingKey;
        return UUID.nameUUIDFromBytes(pseudoID.getBytes(StandardCharsets.UTF_8));
    }

    static class LegacyBinding
    implements LegacyConfiguredObject {
        private static final String ARGUMENTS = "arguments";
        private static final String QUEUE = "queue";
        private static final String EXCHANGE = "exchange";
        private static final Collection<String> ATTRIBUTE_NAMES = Collections.unmodifiableSet(Stream.concat(GenericLegacyConfiguredObject.AVAILABLE_ATTRIBUTES.stream(), Stream.of("arguments", "queue", "exchange")).collect(Collectors.toSet()));
        private final String _bindingKey;
        private final Map<String, Object> _arguments;
        private final LegacyConfiguredObject _exchange;
        private final UUID _id;
        private final LegacyConfiguredObject _queue;
        private final LegacyManagementController _controller;

        LegacyBinding(LegacyManagementController controller, LegacyConfiguredObject nextVersionExchange, LegacyConfiguredObject nextVersionQueue, String bindingKey, Map<String, Object> arguments) {
            this._controller = controller;
            this._exchange = this._controller.convertFromNextVersion(nextVersionExchange);
            this._queue = this._controller.convertFromNextVersion(nextVersionQueue);
            this._bindingKey = bindingKey;
            this._arguments = arguments != null && !arguments.isEmpty() ? arguments : null;
            String queueName = (String)nextVersionQueue.getAttribute("name");
            this._id = BindingController.generateBindingId(nextVersionExchange, queueName, bindingKey);
        }

        @Override
        public Collection<String> getAttributeNames() {
            return ATTRIBUTE_NAMES;
        }

        @Override
        public Object getAttribute(String name) {
            if ("id".equalsIgnoreCase(name)) {
                return this._id;
            }
            if ("name".equalsIgnoreCase(name)) {
                return this._bindingKey;
            }
            if ("state".equalsIgnoreCase(name) || "desiredState".equalsIgnoreCase(name)) {
                return State.ACTIVE;
            }
            if ("type".equalsIgnoreCase(name)) {
                return "type";
            }
            if ("context".equalsIgnoreCase(name)) {
                return this._exchange.getAttribute("context");
            }
            if (QUEUE.equalsIgnoreCase(name)) {
                return this._queue;
            }
            if (EXCHANGE.equalsIgnoreCase(name)) {
                return this._exchange;
            }
            if ("durable".equalsIgnoreCase(name)) {
                return Boolean.TRUE.equals(this._queue.getAttribute("durable")) && Boolean.TRUE.equals(this._exchange.getAttribute("durable"));
            }
            if ("lifetimePolicy".equalsIgnoreCase(name)) {
                return this._queue.getAttribute("lifetimePolicy");
            }
            if (ARGUMENTS.equalsIgnoreCase(name)) {
                return this._arguments;
            }
            return null;
        }

        @Override
        public Object getActualAttribute(String name) {
            if (QUEUE.equalsIgnoreCase(name)) {
                return this._queue.getAttribute("name");
            }
            if (EXCHANGE.equalsIgnoreCase(name)) {
                return this._exchange.getAttribute("name");
            }
            return this.getAttribute(name);
        }

        @Override
        public Collection<LegacyConfiguredObject> getChildren(String category) {
            return Collections.emptyList();
        }

        @Override
        public String getCategory() {
            return BindingController.TYPE;
        }

        @Override
        public ManagementResponse invoke(String operation, Map<String, Object> parameters, boolean isSecure) {
            if ("getStatistics".equals(operation)) {
                return new ControllerManagementResponse(ResponseType.DATA, Collections.emptyMap());
            }
            throw ManagementException.createBadRequestManagementException("No operation is available for Binding");
        }

        @Override
        public LegacyConfiguredObject getNextVersionConfiguredObject() {
            return null;
        }

        public void delete() {
            LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
            parameters.put("bindingKey", this.getAttribute("name"));
            parameters.put("destination", this._queue.getAttribute("name"));
            this._exchange.getNextVersionConfiguredObject().invoke("unbind", parameters, true);
        }

        @Override
        public LegacyConfiguredObject getParent(String category) {
            if ("Queue".equalsIgnoreCase(category)) {
                return this._queue;
            }
            if ("Exchange".equalsIgnoreCase(category)) {
                return this._exchange;
            }
            throw ManagementException.createInternalServerErrorManagementException(String.format("Category %s is not parent of Binding", category));
        }

        @Override
        public boolean isSecureAttribute(String name) {
            return false;
        }

        @Override
        public boolean isOversizedAttribute(String name) {
            return false;
        }

        @Override
        public String getContextValue(String contextKey) {
            return this._exchange.getContextValue(contextKey);
        }

        @Override
        public Map<String, Object> getStatistics() {
            return Collections.emptyMap();
        }
    }
}

