/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.inject.CreationException;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import com.hivemq.exceptions.UnrecoverableException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMQExceptionHandlerBootstrap {
    private static final Logger log = LoggerFactory.getLogger(HiveMQExceptionHandlerBootstrap.class);

    public static void addUnrecoverableExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                HiveMQExceptionHandlerBootstrap.handleUncaughtException(t, e);
            }
        });
    }

    @VisibleForTesting
    static void handleUncaughtException(Thread t, Throwable e) {
        if (e instanceof UnrecoverableException) {
            if (((UnrecoverableException)e).isShowException()) {
                log.error("An unrecoverable Exception occurred. Exiting HiveMQ", (Object)t, (Object)e);
            }
            System.exit(1);
        } else if (e instanceof CreationException) {
            if (e.getCause() instanceof UnrecoverableException) {
                log.error("An unrecoverable Exception occurred. Exiting HiveMQ");
                System.exit(1);
            }
            CreationException creationException = (CreationException)e;
            HiveMQExceptionHandlerBootstrap.checkGuiceErrorsForUnrecoverable(creationException.getErrorMessages());
        } else if (e instanceof ProvisionException) {
            if (e.getCause() instanceof UnrecoverableException) {
                log.error("An unrecoverable Exception occurred. Exiting HiveMQ");
                System.exit(1);
            }
            ProvisionException provisionException = (ProvisionException)e;
            HiveMQExceptionHandlerBootstrap.checkGuiceErrorsForUnrecoverable(provisionException.getErrorMessages());
        }
        Throwable rootCause = Throwables.getRootCause((Throwable)e);
        if (rootCause instanceof UnrecoverableException) {
            boolean showException = ((UnrecoverableException)rootCause).isShowException();
            if (showException) {
                log.error("Cause: ", e);
            }
        } else {
            log.error("Uncaught Error:", e);
        }
    }

    private static void checkGuiceErrorsForUnrecoverable(Collection<Message> errorMessages) {
        if (errorMessages == null) {
            return;
        }
        for (Message message : errorMessages) {
            if (!(message.getCause() instanceof UnrecoverableException)) continue;
            log.error("An unrecoverable Exception occurred. Exiting HiveMQ");
            System.exit(1);
        }
    }
}

