/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder;

import com.google.common.base.Utf8;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.decoder.AbstractMqttDecoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.Message;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.util.Bytes;
import io.netty.buffer.ByteBuf;

public abstract class AbstractMqttPublishDecoder<T extends Message>
extends AbstractMqttDecoder<T> {
    private static final byte @NotNull [] EMPTY_PAYLOAD = new byte[0];

    protected AbstractMqttPublishDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
    }

    protected int decodeQoS(@NotNull ClientConnectionContext clientConnectionContext, byte header) {
        int qos = (header & 6) >> 1;
        if (qos == 3) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PUBLISH with an invalid QoS. Disconnecting client.", "Sent a PUBLISH with an invalid QoS", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, "PUBLISH with quality of service set to '3' was sent.");
            return -1;
        }
        return qos;
    }

    @Nullable
    protected Boolean decodeDup(@NotNull ClientConnectionContext clientConnectionContext, byte header, int qos) {
        boolean dup = Bytes.isBitSet(header, 3);
        if (qos == 0 && dup) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PUBLISH with QoS 0 and DUP set to 1. Disconnecting client.", "Sent a PUBLISH with QoS 0 and DUP set to 1", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "PUBLISH with quality of service set to '0' and DUP flag set to true was sent. This is a protocol violation.");
            return null;
        }
        return dup;
    }

    @Nullable
    protected Boolean decodeRetain(@NotNull ClientConnectionContext clientConnectionContext, byte header) {
        boolean retained = Bytes.isBitSet(header, 0);
        if (retained && !this.configurationService.mqttConfiguration().retainedMessagesEnabled()) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PUBLISH with retain set to 1 although retain is not available. Disconnecting client.", "Sent a PUBLISH with retain set to 1 although retain is not available", Mqtt5DisconnectReasonCode.RETAIN_NOT_SUPPORTED, "PUBLISH with retain flag set to true was sent. The broker does not allow this.");
            return null;
        }
        return retained;
    }

    protected int decodePacketIdentifier(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf) {
        int packetIdentifier = buf.readUnsignedShort();
        if (packetIdentifier == 0) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PUBLISH with QoS > 0 and packet identifier 0. Disconnecting client.", "Sent a PUBLISH with QoS > 0 and packet identifier 0", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "PUBLISH with quality of service level greater than zero and packet identifier of '0' was sent. This is a protocol violation.");
        }
        return packetIdentifier;
    }

    protected byte @Nullable [] decodePayload(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int payloadLength, @Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator, boolean validatePayloadFormat) {
        byte[] payload;
        if (payloadLength > 0) {
            payload = new byte[payloadLength];
            buf.readBytes(payload);
            if (payloadFormatIndicator == Mqtt5PayloadFormatIndicator.UTF_8 && validatePayloadFormat && !Utf8.isWellFormed((byte[])payload)) {
                this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PUBLISH with an invalid UTF-8 payload. This is not allowed. Disconnecting client.", "Sent a PUBLISH with an invalid UTF-8 payload", Mqtt5DisconnectReasonCode.PAYLOAD_FORMAT_INVALID, "PUBLISH with no valid UTF-8 payload was sent.");
                return null;
            }
        } else {
            payload = EMPTY_PAYLOAD;
        }
        return payload;
    }
}

