/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt3;

import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttDecoder;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import io.netty.buffer.ByteBuf;

@LazySingleton
public class Mqtt3PubrelDecoder
extends AbstractMqttDecoder<PUBREL> {
    @Inject
    public Mqtt3PubrelDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
    }

    @Override
    @Nullable
    public PUBREL decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        if (clientConnectionContext.getProtocolVersion() == ProtocolVersion.MQTTv3_1_1 && !this.validateHeader(header)) {
            this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.PUBREL);
            buf.clear();
            return null;
        }
        if (buf.readableBytes() < 2) {
            this.disconnectByNoMessageId(clientConnectionContext, MessageType.PUBREL);
            buf.clear();
            return null;
        }
        int messageId = buf.readUnsignedShort();
        return new PUBREL(messageId);
    }

    @Override
    protected boolean validateHeader(byte header) {
        return (header & 2) == 2;
    }
}

