/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt5;

import com.google.common.collect.ImmutableList;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttDecoder;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.pubcomp.Mqtt5PUBCOMP;
import com.hivemq.mqtt.message.pubcomp.PUBCOMP;
import com.hivemq.mqtt.message.reason.Mqtt5PubCompReasonCode;
import io.netty.buffer.ByteBuf;
import javax.inject.Inject;

@LazySingleton
public class Mqtt5PubcompDecoder
extends AbstractMqttDecoder<PUBCOMP> {
    @Inject
    public Mqtt5PubcompDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
    }

    @Override
    @Nullable
    public PUBCOMP decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        if (!this.validateHeader(header)) {
            this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.PUBCOMP);
            return null;
        }
        if (buf.readableBytes() < 2) {
            this.disconnectByRemainingLengthToShort(clientConnectionContext, MessageType.PUBCOMP);
            return null;
        }
        int packetIdentifier = this.decodePacketIdentifier(clientConnectionContext, buf, MessageType.PUBCOMP);
        if (packetIdentifier == 0) {
            return null;
        }
        if (!buf.isReadable()) {
            return new PUBCOMP(packetIdentifier, Mqtt5PUBCOMP.DEFAULT_REASON_CODE, null, Mqtt5UserProperties.NO_USER_PROPERTIES);
        }
        Mqtt5PubCompReasonCode reasonCode = Mqtt5PubCompReasonCode.fromCode(buf.readUnsignedByte());
        if (reasonCode == null) {
            this.disconnectByInvalidReasonCode(clientConnectionContext, MessageType.PUBCOMP);
            return null;
        }
        if (!buf.isReadable()) {
            return new PUBCOMP(packetIdentifier, reasonCode, null, Mqtt5UserProperties.NO_USER_PROPERTIES);
        }
        int propertiesLength = this.decodePropertiesLengthNoPayload(clientConnectionContext, buf, MessageType.PUBCOMP);
        if (propertiesLength == -1) {
            return null;
        }
        String reasonString = null;
        ImmutableList.Builder<MqttUserProperty> userPropertiesBuilder = null;
        block4: while (buf.isReadable()) {
            byte propertyIdentifier = buf.readByte();
            switch (propertyIdentifier) {
                case 31: {
                    if ((reasonString = this.decodeReasonString(clientConnectionContext, buf, reasonString, MessageType.PUBCOMP)) != null) continue block4;
                    return null;
                }
                case 38: {
                    if ((userPropertiesBuilder = this.readUserProperty(clientConnectionContext, buf, userPropertiesBuilder, MessageType.PUBCOMP)) != null) continue block4;
                    return null;
                }
            }
            this.disconnectByInvalidPropertyIdentifier(clientConnectionContext, propertyIdentifier, MessageType.PUBCOMP);
            return null;
        }
        Mqtt5UserProperties userProperties = Mqtt5UserProperties.build(userPropertiesBuilder);
        if (this.invalidUserPropertiesLength(clientConnectionContext, MessageType.PUBCOMP, userProperties)) {
            return null;
        }
        return new PUBCOMP(packetIdentifier, reasonCode, reasonString, userProperties);
    }
}

