/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.service.entity;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.entity.TcpListener;
import com.hivemq.configuration.service.entity.Tls;
import com.hivemq.configuration.service.entity.TlsListener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;

public class TlsTcpListener
extends TcpListener
implements TlsListener {
    @NotNull
    private final Tls tls;

    @Deprecated
    public TlsTcpListener(int port, @NotNull String bindAddress, @NotNull Tls tls) {
        this(port, bindAddress, tls, "tls-tcp-listener-" + port);
    }

    public TlsTcpListener(int port, @NotNull String bindAddress, @NotNull Tls tls, @NotNull String name) {
        super(port, bindAddress, name);
        Preconditions.checkNotNull((Object)tls);
        this.tls = tls;
    }

    @Override
    @NotNull
    public Tls getTls() {
        return this.tls;
    }

    @Override
    @NotNull
    public String readableName() {
        return "TCP Listener with TLS";
    }

    public static class Builder {
        @Nullable
        private String name;
        @Nullable
        private Integer port;
        @Nullable
        private String bindAddress;
        @Nullable
        private Tls tls;

        @NotNull
        public Builder from(@NotNull TlsTcpListener tlsTcpListener) {
            this.port = tlsTcpListener.getPort();
            this.bindAddress = tlsTcpListener.getBindAddress();
            this.name = tlsTcpListener.getName();
            this.tls = tlsTcpListener.getTls();
            return this;
        }

        @NotNull
        public Builder tls(@NotNull Tls tls) {
            Preconditions.checkNotNull((Object)tls);
            this.tls = tls;
            return this;
        }

        @NotNull
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @NotNull
        public Builder bindAddress(@NotNull String bindAddress) {
            Preconditions.checkNotNull((Object)bindAddress);
            this.bindAddress = bindAddress;
            return this;
        }

        @NotNull
        public Builder name(@NotNull String name) {
            Preconditions.checkNotNull((Object)name);
            this.name = name;
            return this;
        }

        @NotNull
        public TlsTcpListener build() throws IllegalStateException {
            if (this.port == null) {
                throw new IllegalStateException("The port for a TLS TCP listener was not set.");
            }
            if (this.bindAddress == null) {
                throw new IllegalStateException("The bind address for a TLS TCP listener was not set.");
            }
            if (this.name == null) {
                this.name = "tls-tcp-listener-" + this.port;
            }
            if (this.tls == null) {
                throw new IllegalStateException("The TLS settings for a TLS TCP listener was not set.");
            }
            return new TlsTcpListener(this.port, this.bindAddress, this.tls, this.name);
        }
    }
}

