/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ClientState;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.auth.AuthContext;
import com.hivemq.extensions.auth.ReAuthOutput;
import com.hivemq.extensions.auth.parameter.ModifiableClientSettingsImpl;
import com.hivemq.extensions.events.OnAuthSuccessEvent;
import com.hivemq.mqtt.handler.auth.MqttAuthSender;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5AuthReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;

public class ReAuthContext
extends AuthContext<ReAuthOutput> {
    @NotNull
    private final MqttServerDisconnector disconnector;

    public ReAuthContext(@NotNull String identifier, @NotNull ChannelHandlerContext ctx, @NotNull MqttAuthSender authSender, int authenticatorsCount, @NotNull ReAuthOutput output, @NotNull MqttServerDisconnector disconnector) {
        super(identifier, ctx, authSender, authenticatorsCount, output);
        this.disconnector = disconnector;
    }

    @Override
    @NotNull
    ReAuthOutput createNextOutput(@NotNull ReAuthOutput prevOutput) {
        return new ReAuthOutput(prevOutput);
    }

    @Override
    void succeedAuthentication(@NotNull ReAuthOutput output) {
        super.succeedAuthentication(output);
        Channel channel = this.ctx.channel();
        this.applyClientSettings(output.getClientSettings(), channel);
        ChannelFuture authFuture = this.authSender.sendAuth(channel, output.getAuthenticationData(), Mqtt5AuthReasonCode.SUCCESS, Mqtt5UserProperties.of(output.getOutboundUserProperties().asInternalList()), output.getReasonString());
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        clientConnectionContext.proposeClientState(ClientState.AUTHENTICATED);
        authFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                this.ctx.pipeline().fireUserEventTriggered((Object)new OnAuthSuccessEvent());
            } else if (future.channel().isActive()) {
                this.onSendException(future.cause());
            }
        }));
    }

    @Override
    void failAuthentication(@NotNull ReAuthOutput output) {
        this.disconnector.disconnect(this.ctx.channel(), "Client with ip {} could not be re-authenticated", "Re-authentication failed", output.getReasonCode(), output.getReasonString(), Mqtt5UserProperties.of(output.getOutboundUserProperties().asInternalList()), true, false);
    }

    @Override
    void undecidedAuthentication(@NotNull ReAuthOutput output) {
        this.disconnector.disconnect(this.ctx.channel(), "Client with ip {} could not be re-authenticated", "Re-authentication failed, no authenticator registered", Mqtt5DisconnectReasonCode.NOT_AUTHORIZED, "Re-authentication failed, no authenticator registered", Mqtt5UserProperties.NO_USER_PROPERTIES, true, false);
    }

    @Override
    void onTimeout() {
        this.disconnector.disconnect(this.ctx.channel(), "Client with ip {} could not be re-authenticated", "Re-authentication failed, timeout before the client provided required authentication data", Mqtt5DisconnectReasonCode.NOT_AUTHORIZED, "Re-authentication failed, timeout before the client provided required authentication data", Mqtt5UserProperties.NO_USER_PROPERTIES, true, false);
    }

    @Override
    void onSendException(@NotNull Throwable cause) {
        this.disconnector.disconnect(this.ctx.channel(), "Client with ip {} could not be re-authenticated", "Re-authentication failed, could not send AUTH to client", Mqtt5DisconnectReasonCode.NOT_AUTHORIZED, "Re-authentication failed, could not send AUTH to client", Mqtt5UserProperties.NO_USER_PROPERTIES, true, false);
    }

    private void applyClientSettings(@NotNull ModifiableClientSettingsImpl clientSettings, @NotNull Channel channel) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        clientConnectionContext.setClientReceiveMaximum(clientSettings.getClientReceiveMaximum());
        clientConnectionContext.setQueueSizeMaximum(clientSettings.getQueueSizeMaximum());
    }
}

