/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.classloader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.services.Services;
import com.hivemq.extension.sdk.api.services.builder.Builders;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedExtensionClassloader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(IsolatedExtensionClassloader.class);
    @VisibleForTesting
    private static final ImmutableSet<String> restrictedPackages = new ImmutableSet.Builder().add((Object[])new String[]{"java.", "javax.annotation", "jdk.", "com.hivemq.extension.sdk.api", "org.slf4j", "com.codahale.metrics"}).build();
    private static final ImmutableSet<Class<?>> classesWithStaticContext = new ImmutableSet.Builder().add((Object[])new Class[]{Services.class, Builders.class}).build();
    private static final ImmutableSet<String> classNamesWithStaticContext = new ImmutableSet.Builder().add((Object[])new String[]{Services.class.getCanonicalName(), Builders.class.getCanonicalName()}).build();
    @Nullable
    private final ClassLoader delegate;

    public IsolatedExtensionClassloader(@NotNull @NotNull URL @NotNull [] classpath, @NotNull ClassLoader parent) {
        super(classpath, parent);
        this.delegate = null;
    }

    public IsolatedExtensionClassloader(@NotNull ClassLoader delegate, @NotNull ClassLoader parent) {
        super(new URL[0], parent);
        this.delegate = delegate;
    }

    public void loadClassesWithStaticContext() {
        for (Class staticClass : classesWithStaticContext) {
            try {
                InputStream resourceAsStream = staticClass.getResourceAsStream(staticClass.getSimpleName() + ".class");
                try {
                    if (resourceAsStream == null) continue;
                    byte[] bytes = resourceAsStream.readAllBytes();
                    this.defineClass(staticClass.getCanonicalName(), bytes, 0, bytes.length);
                }
                finally {
                    if (resourceAsStream == null) continue;
                    resourceAsStream.close();
                }
            }
            catch (IOException e) {
                log.error("Not able to load extension class files for classes with static context", (Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    protected synchronized Class<?> loadClass(@NotNull String name, boolean resolve) throws ClassNotFoundException {
        if (this.delegate != null) {
            return this.delegate.loadClass(name);
        }
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (classNamesWithStaticContext.contains((Object)name)) {
            c = this.findClass(name);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        if (this.mustLoadFromParentClassloader(name)) {
            try {
                c = super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException e) {
                c = this.findClass(name);
            }
        } else {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                c = super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private boolean mustLoadFromParentClassloader(@NotNull String name) {
        for (String packageName : restrictedPackages) {
            if (!name.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public URL getResource(@NotNull String name) {
        URL url = this.delegate != null ? this.delegate.getResource(name) : this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    @NotNull
    public Enumeration<URL> getResources(@NotNull String name) throws IOException {
        Enumeration<URL> localUrls = this.delegate != null ? this.delegate.getResources(name) : this.findResources(name);
        Enumeration<URL> parentUrls = null;
        if (this.getParent() != null) {
            parentUrls = this.getParent().getResources(name);
        }
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (localUrls != null) {
            while (localUrls.hasMoreElements()) {
                urls.add(localUrls.nextElement());
            }
        }
        if (parentUrls != null) {
            while (parentUrls.hasMoreElements()) {
                urls.add(parentUrls.nextElement());
            }
        }
        return new Enumeration<URL>(){
            final Iterator<URL> iterator;
            {
                this.iterator = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            @NotNull
            public URL nextElement() {
                return this.iterator.next();
            }
        };
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(@NotNull String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

