/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.interceptor.publish.PublishInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.publish.parameter.PublishInboundInput;
import com.hivemq.extension.sdk.api.interceptor.publish.parameter.PublishInboundOutput;
import com.hivemq.extension.sdk.api.packets.publish.AckReasonCode;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.handler.ExtensionParameterHolder;
import com.hivemq.extensions.handler.PluginAuthorizerService;
import com.hivemq.extensions.interceptor.publish.parameter.PublishInboundInputImpl;
import com.hivemq.extensions.interceptor.publish.parameter.PublishInboundOutputImpl;
import com.hivemq.extensions.packets.publish.ModifiablePublishPacketImpl;
import com.hivemq.extensions.packets.publish.PublishPacketImpl;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.puback.PUBACK;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.publish.PUBLISHFactory;
import com.hivemq.mqtt.message.pubrec.PUBREC;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5PubAckReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5PubRecReasonCode;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IncomingPublishHandler {
    private static final Logger log = LoggerFactory.getLogger(IncomingPublishHandler.class);
    @NotNull
    private final PluginTaskExecutorService executorService;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final MessageDroppedService messageDroppedService;
    @NotNull
    private final PluginAuthorizerService authorizerService;
    @NotNull
    private final MqttServerDisconnector mqttDisconnector;
    @NotNull
    private final FullConfigurationService configurationService;

    @Inject
    public IncomingPublishHandler(@NotNull PluginTaskExecutorService executorService, @NotNull PluginOutPutAsyncer asyncer, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull MessageDroppedService messageDroppedService, @NotNull PluginAuthorizerService authorizerService, @NotNull MqttServerDisconnector mqttDisconnector, @NotNull FullConfigurationService configurationService) {
        this.executorService = executorService;
        this.asyncer = asyncer;
        this.hiveMQExtensions = hiveMQExtensions;
        this.messageDroppedService = messageDroppedService;
        this.authorizerService = authorizerService;
        this.mqttDisconnector = mqttDisconnector;
        this.configurationService = configurationService;
    }

    public void interceptOrDelegate(@NotNull ChannelHandlerContext ctx, @NotNull PUBLISH publish, @NotNull String clientId) {
        Channel channel = ctx.channel();
        ClientContextImpl clientContext = ClientConnection.of(channel).getExtensionClientContext();
        if (clientContext == null) {
            ctx.executor().execute(() -> this.authorizerService.authorizePublish(ctx, publish));
            return;
        }
        List<PublishInboundInterceptor> interceptors = clientContext.getPublishInboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.executor().execute(() -> this.authorizerService.authorizePublish(ctx, publish));
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        PublishPacketImpl packet = new PublishPacketImpl(publish);
        PublishInboundInputImpl input = new PublishInboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<PublishInboundInputImpl> inputHolder = new ExtensionParameterHolder<PublishInboundInputImpl>(input);
        ModifiablePublishPacketImpl modifiablePacket = new ModifiablePublishPacketImpl(packet, this.configurationService);
        PublishInboundOutputImpl output = new PublishInboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<PublishInboundOutputImpl> outputHolder = new ExtensionParameterHolder<PublishInboundOutputImpl>(output);
        PublishInboundInterceptorContext context = new PublishInboundInterceptorContext(clientId, interceptors.size(), ctx, publish, inputHolder, outputHolder);
        for (PublishInboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            PublishInboundInterceptorTask task = new PublishInboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    private static class PublishInboundInterceptorTask
    implements PluginInOutTask<PublishInboundInputImpl, PublishInboundOutputImpl> {
        @NotNull
        private final PublishInboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        private PublishInboundInterceptorTask(@NotNull PublishInboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public PublishInboundOutputImpl apply(@NotNull PublishInboundInputImpl input, @NotNull PublishInboundOutputImpl output) {
            if (output.isPreventDelivery()) {
                return output;
            }
            try {
                this.interceptor.onInboundPublish((PublishInboundInput)input, (PublishInboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on inbound PUBLISH interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.forciblyPreventPublishDelivery(output.getReasonCode(), output.getReasonString());
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private class PublishInboundInterceptorContext
    extends PluginInOutTaskContext<PublishInboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final PUBLISH publish;
        @NotNull
        private final ExtensionParameterHolder<PublishInboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<PublishInboundOutputImpl> outputHolder;

        PublishInboundInterceptorContext(String clientId, @NotNull int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull PUBLISH publish, @NotNull ExtensionParameterHolder<PublishInboundInputImpl> inputHolder, ExtensionParameterHolder<PublishInboundOutputImpl> outputHolder) {
            super(clientId);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.publish = publish;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull PublishInboundOutputImpl output) {
            if (output.isPreventDelivery()) {
                this.finishInterceptor();
            } else if (output.isTimedOut() && output.getTimeoutFallback() == TimeoutFallback.FAILURE) {
                output.forciblyPreventPublishDelivery(output.getReasonCode(), output.getReasonString());
                this.finishInterceptor();
            } else {
                if (output.getPublishPacket().isModified()) {
                    this.inputHolder.set(this.inputHolder.get().update(output));
                }
                if (!this.finishInterceptor()) {
                    this.outputHolder.set(output.update(this.inputHolder.get()));
                }
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            PublishInboundOutputImpl output = this.outputHolder.get();
            if (output.isPreventDelivery()) {
                this.dropMessage(output);
            } else {
                PUBLISH finalPublish = PUBLISHFactory.merge(this.inputHolder.get().getPublishPacket(), this.publish);
                IncomingPublishHandler.this.authorizerService.authorizePublish(this.ctx, finalPublish);
            }
        }

        private void dropMessage(@NotNull PublishInboundOutputImpl output) {
            Channel channel = this.ctx.channel();
            String clientId = this.getIdentifier();
            ProtocolVersion protocolVersion = ClientConnection.of(channel).getProtocolVersion();
            if (protocolVersion != ProtocolVersion.MQTTv5) {
                if (output.getReasonCode() != AckReasonCode.SUCCESS) {
                    IncomingPublishHandler.this.mqttDisconnector.disconnect(channel, "Client '" + clientId + "' (IP: {}) sent a PUBLISH, but its onward delivery was prevented by a publish inbound interceptor. Disconnecting client.", "Sent PUBLISH, but its onward delivery was prevented by a publish inbound interceptor", Mqtt5DisconnectReasonCode.ADMINISTRATIVE_ACTION, null);
                } else {
                    switch (this.publish.getQoS()) {
                        case AT_MOST_ONCE: {
                            break;
                        }
                        case AT_LEAST_ONCE: {
                            this.ctx.writeAndFlush((Object)new PUBACK(this.publish.getPacketIdentifier()));
                            break;
                        }
                        case EXACTLY_ONCE: {
                            this.ctx.writeAndFlush((Object)new PUBREC(this.publish.getPacketIdentifier()));
                        }
                    }
                }
            } else {
                switch (this.publish.getQoS()) {
                    case AT_MOST_ONCE: {
                        break;
                    }
                    case AT_LEAST_ONCE: {
                        Mqtt5PubAckReasonCode ackReasonCode = Mqtt5PubAckReasonCode.from(output.getReasonCode());
                        this.ctx.writeAndFlush((Object)new PUBACK(this.publish.getPacketIdentifier(), ackReasonCode, output.getReasonString(), Mqtt5UserProperties.NO_USER_PROPERTIES));
                        break;
                    }
                    case EXACTLY_ONCE: {
                        Mqtt5PubRecReasonCode recReasonCode = Mqtt5PubRecReasonCode.from(output.getReasonCode());
                        this.ctx.writeAndFlush((Object)new PUBREC(this.publish.getPacketIdentifier(), recReasonCode, output.getReasonString(), Mqtt5UserProperties.NO_USER_PROPERTIES));
                    }
                }
            }
            IncomingPublishHandler.this.messageDroppedService.extensionPrevented(clientId, this.publish.getTopic(), this.publish.getQoS().getQosNumber());
        }
    }
}

