/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.interceptor.publish.parameter;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.async.Async;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extension.sdk.api.interceptor.publish.parameter.PublishInboundOutput;
import com.hivemq.extension.sdk.api.packets.publish.AckReasonCode;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.task.AbstractAsyncOutput;
import com.hivemq.extensions.interceptor.publish.parameter.PublishInboundInputImpl;
import com.hivemq.extensions.packets.publish.ModifiablePublishPacketImpl;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;

public class PublishInboundOutputImpl
extends AbstractAsyncOutput<PublishInboundOutput>
implements PublishInboundOutput {
    @NotNull
    private final ModifiablePublishPacketImpl publishPacket;
    @NotNull
    private final AtomicBoolean preventDelivery = new AtomicBoolean(false);
    @NotNull
    private AckReasonCode reasonCode = AckReasonCode.SUCCESS;
    @Nullable
    private String reasonString;

    public PublishInboundOutputImpl(@NotNull PluginOutPutAsyncer asyncer, @NotNull ModifiablePublishPacketImpl publishPacket) {
        super(asyncer);
        this.publishPacket = publishPacket;
    }

    @NotNull
    public ModifiablePublishPacketImpl getPublishPacket() {
        return this.publishPacket;
    }

    public void preventPublishDelivery() {
        this.preventPublishDelivery(AckReasonCode.SUCCESS, null);
    }

    public void preventPublishDelivery(@NotNull AckReasonCode reasonCode) {
        this.preventPublishDelivery(reasonCode, null);
    }

    public void preventPublishDelivery(@NotNull AckReasonCode reasonCode, @Nullable String reasonString) {
        Preconditions.checkNotNull((Object)reasonCode, (Object)"reason code must never be null");
        if (reasonCode == AckReasonCode.SUCCESS) {
            Preconditions.checkArgument((reasonString == null ? 1 : 0) != 0, (Object)"reason string must not be set when ack reason code is success");
        }
        this.checkPrevented();
        this.reasonCode = reasonCode;
        this.reasonString = reasonString;
    }

    public void forciblyPreventPublishDelivery(@NotNull AckReasonCode reasonCode, @Nullable String reasonString) {
        Preconditions.checkNotNull((Object)reasonCode, (Object)"reason code must never be null");
        this.preventDelivery.set(true);
        this.reasonCode = reasonCode;
        this.reasonString = reasonString;
    }

    @NotNull
    public Async<PublishInboundOutput> async(@NotNull Duration duration, @NotNull TimeoutFallback timeoutFallback, @NotNull AckReasonCode ackReasonCode) {
        return this.async(duration, timeoutFallback, ackReasonCode, null);
    }

    @NotNull
    public Async<PublishInboundOutput> async(@NotNull Duration duration, @NotNull TimeoutFallback timeoutFallback, @NotNull AckReasonCode ackReasonCode, @Nullable String reasonString) {
        Preconditions.checkNotNull((Object)duration, (Object)"Duration must never be null");
        Preconditions.checkNotNull((Object)timeoutFallback, (Object)"Fallback must never be null");
        if (timeoutFallback == TimeoutFallback.SUCCESS) {
            Preconditions.checkArgument((ackReasonCode == AckReasonCode.SUCCESS ? 1 : 0) != 0, (Object)"reason code must be success when fallback success");
        }
        if (ackReasonCode == AckReasonCode.SUCCESS) {
            Preconditions.checkArgument((reasonString == null ? 1 : 0) != 0, (Object)"reason string must not be set when ack reason code is success");
        }
        Preconditions.checkNotNull((Object)ackReasonCode, (Object)"Reason code must never be null");
        Async async = super.async(duration, timeoutFallback);
        this.reasonCode = ackReasonCode;
        this.reasonString = reasonString;
        return async;
    }

    public boolean isPreventDelivery() {
        return this.preventDelivery.get();
    }

    @NotNull
    public AckReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @Nullable
    public String getReasonString() {
        return this.reasonString;
    }

    private void checkPrevented() {
        if (!this.preventDelivery.compareAndSet(false, true)) {
            throw new UnsupportedOperationException("preventPublishDelivery must not be called more than once");
        }
    }

    @NotNull
    public PublishInboundOutputImpl update(@NotNull PublishInboundInputImpl input) {
        return new PublishInboundOutputImpl(this.asyncer, this.publishPacket.update(input.getPublishPacket()));
    }
}

