/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.auth;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.auth.AuthPacket;
import com.hivemq.extension.sdk.api.packets.auth.AuthReasonCode;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.mqtt.message.auth.AUTH;
import com.hivemq.mqtt.message.reason.Mqtt5AuthReasonCode;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class AuthPacketImpl
implements AuthPacket {
    @NotNull
    private final AuthReasonCode reasonCode;
    @NotNull
    private final String method;
    @Nullable
    private final byte[] data;
    @Nullable
    private final String reasonString;
    @NotNull
    private final UserPropertiesImpl userProperties;

    public AuthPacketImpl(@NotNull AuthReasonCode reasonCode, @NotNull String method, @Nullable byte[] data, @Nullable String reasonString, @NotNull UserPropertiesImpl userProperties) {
        this.reasonCode = reasonCode;
        this.method = method;
        this.data = data;
        this.reasonString = reasonString;
        this.userProperties = userProperties;
    }

    public AuthPacketImpl(@NotNull AUTH auth) {
        this(((Mqtt5AuthReasonCode)auth.getReasonCode()).toAuthReasonCode(), auth.getAuthMethod(), auth.getAuthData(), auth.getReasonString(), UserPropertiesImpl.of(auth.getUserProperties().asList()));
    }

    @NotNull
    public AuthReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @NotNull
    public String getAuthenticationMethod() {
        return this.method;
    }

    @NotNull
    public Optional<ByteBuffer> getAuthenticationData() {
        if (this.data == null) {
            return Optional.empty();
        }
        return Optional.of(ByteBuffer.wrap(this.data).asReadOnlyBuffer());
    }

    @NotNull
    public Optional<byte[]> getAuthenticationDataAsArray() {
        if (this.data == null) {
            return Optional.empty();
        }
        return Optional.of(Arrays.copyOf(this.data, this.data.length));
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthPacketImpl)) {
            return false;
        }
        AuthPacketImpl that = (AuthPacketImpl)o;
        return this.reasonCode == that.reasonCode && this.method.equals(that.method) && Arrays.equals(this.data, that.data) && Objects.equals(this.reasonString, that.reasonString) && this.userProperties.equals(that.userProperties);
    }

    public int hashCode() {
        int result = Objects.hash(this.reasonCode, this.method, this.reasonString, this.userProperties);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

