/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.connack;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.connack.ConnackPacket;
import com.hivemq.extension.sdk.api.packets.connect.ConnackReasonCode;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.mqtt.message.connack.CONNACK;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;

public class ConnackPacketImpl
implements ConnackPacket {
    @NotNull
    final ConnackReasonCode reasonCode;
    final boolean sessionPresent;
    final long sessionExpiryInterval;
    final int serverKeepAlive;
    @Nullable
    final String assignedClientId;
    @Nullable
    final String authenticationMethod;
    @Nullable
    final ByteBuffer authenticationData;
    final int receiveMaximum;
    final int maximumPacketSize;
    final int topicAliasMaximum;
    @Nullable
    final Qos maximumQos;
    final boolean retainAvailable;
    final boolean wildCardSubscriptionAvailable;
    final boolean sharedSubscriptionsAvailable;
    final boolean subscriptionIdentifiersAvailable;
    @Nullable
    final String responseInformation;
    @Nullable
    final String serverReference;
    @Nullable
    final String reasonString;
    @NotNull
    final UserPropertiesImpl userProperties;

    public ConnackPacketImpl(@NotNull ConnackReasonCode reasonCode, boolean sessionPresent, long sessionExpiryInterval, int serverKeepAlive, @Nullable String assignedClientId, @Nullable String authenticationMethod, @Nullable ByteBuffer authenticationData, int receiveMaximum, int maximumPacketSize, int topicAliasMaximum, @Nullable Qos maximumQos, boolean retainAvailable, boolean wildCardSubscriptionAvailable, boolean sharedSubscriptionsAvailable, boolean subscriptionIdentifiersAvailable, @Nullable String responseInformation, @Nullable String serverReference, @Nullable String reasonString, @NotNull UserPropertiesImpl userProperties) {
        this.reasonCode = reasonCode;
        this.sessionPresent = sessionPresent;
        this.sessionExpiryInterval = sessionExpiryInterval;
        this.serverKeepAlive = serverKeepAlive;
        this.assignedClientId = assignedClientId;
        this.authenticationMethod = authenticationMethod;
        this.authenticationData = authenticationData;
        this.receiveMaximum = receiveMaximum;
        this.maximumPacketSize = maximumPacketSize;
        this.topicAliasMaximum = topicAliasMaximum;
        this.maximumQos = maximumQos;
        this.retainAvailable = retainAvailable;
        this.wildCardSubscriptionAvailable = wildCardSubscriptionAvailable;
        this.sharedSubscriptionsAvailable = sharedSubscriptionsAvailable;
        this.subscriptionIdentifiersAvailable = subscriptionIdentifiersAvailable;
        this.responseInformation = responseInformation;
        this.serverReference = serverReference;
        this.reasonString = reasonString;
        this.userProperties = userProperties;
    }

    public ConnackPacketImpl(@NotNull CONNACK connack) {
        this(((Mqtt5ConnAckReasonCode)connack.getReasonCode()).toConnackReasonCode(), connack.isSessionPresent(), connack.getSessionExpiryInterval(), connack.getServerKeepAlive(), connack.getAssignedClientIdentifier(), connack.getAuthMethod(), connack.getAuthData() == null ? null : ByteBuffer.wrap(connack.getAuthData()), connack.getReceiveMaximum(), connack.getMaximumPacketSize(), connack.getTopicAliasMaximum(), connack.getMaximumQoS() == null ? null : connack.getMaximumQoS().toQos(), connack.isRetainAvailable(), connack.isWildcardSubscriptionAvailable(), connack.isSharedSubscriptionAvailable(), connack.isSubscriptionIdentifierAvailable(), connack.getResponseInformation(), connack.getServerReference(), connack.getReasonString(), UserPropertiesImpl.of(connack.getUserProperties().asList()));
    }

    @NotNull
    public ConnackReasonCode getReasonCode() {
        return this.reasonCode;
    }

    public boolean getSessionPresent() {
        return this.sessionPresent;
    }

    @NotNull
    public Optional<Long> getSessionExpiryInterval() {
        if (this.sessionExpiryInterval == Long.MAX_VALUE) {
            return Optional.empty();
        }
        return Optional.of(this.sessionExpiryInterval);
    }

    @NotNull
    public Optional<Integer> getServerKeepAlive() {
        if (this.serverKeepAlive == -1) {
            return Optional.empty();
        }
        return Optional.of(this.serverKeepAlive);
    }

    @NotNull
    public Optional<String> getAssignedClientIdentifier() {
        return Optional.ofNullable(this.assignedClientId);
    }

    @NotNull
    public Optional<String> getAuthenticationMethod() {
        return Optional.ofNullable(this.authenticationMethod);
    }

    @NotNull
    public Optional<ByteBuffer> getAuthenticationData() {
        return this.authenticationData == null ? Optional.empty() : Optional.of(this.authenticationData.asReadOnlyBuffer());
    }

    public int getReceiveMaximum() {
        return this.receiveMaximum;
    }

    public int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    @NotNull
    public Optional<Qos> getMaximumQoS() {
        return Optional.ofNullable(this.maximumQos);
    }

    public boolean getRetainAvailable() {
        return this.retainAvailable;
    }

    public boolean getWildCardSubscriptionAvailable() {
        return this.wildCardSubscriptionAvailable;
    }

    public boolean getSharedSubscriptionsAvailable() {
        return this.sharedSubscriptionsAvailable;
    }

    public boolean getSubscriptionIdentifiersAvailable() {
        return this.subscriptionIdentifiersAvailable;
    }

    @NotNull
    public Optional<String> getResponseInformation() {
        return Optional.ofNullable(this.responseInformation);
    }

    @NotNull
    public Optional<String> getServerReference() {
        return Optional.ofNullable(this.serverReference);
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnackPacketImpl)) {
            return false;
        }
        ConnackPacketImpl that = (ConnackPacketImpl)o;
        return this.reasonCode == that.reasonCode && this.sessionPresent == that.sessionPresent && this.sessionExpiryInterval == that.sessionExpiryInterval && this.serverKeepAlive == that.serverKeepAlive && Objects.equals(this.assignedClientId, that.assignedClientId) && Objects.equals(this.authenticationMethod, that.authenticationMethod) && Objects.equals(this.authenticationData, that.authenticationData) && this.receiveMaximum == that.receiveMaximum && this.maximumPacketSize == that.maximumPacketSize && this.topicAliasMaximum == that.topicAliasMaximum && this.maximumQos == that.maximumQos && this.retainAvailable == that.retainAvailable && this.wildCardSubscriptionAvailable == that.wildCardSubscriptionAvailable && this.sharedSubscriptionsAvailable == that.sharedSubscriptionsAvailable && this.subscriptionIdentifiersAvailable == that.subscriptionIdentifiersAvailable && Objects.equals(this.responseInformation, that.responseInformation) && Objects.equals(this.serverReference, that.serverReference) && Objects.equals(this.reasonString, that.reasonString) && this.userProperties.equals(that.userProperties);
    }

    public int hashCode() {
        return Objects.hash(this.reasonCode, this.sessionPresent, this.sessionExpiryInterval, this.serverKeepAlive, this.assignedClientId, this.authenticationMethod, this.authenticationData, this.receiveMaximum, this.maximumPacketSize, this.topicAliasMaximum, this.maximumQos, this.retainAvailable, this.wildCardSubscriptionAvailable, this.sharedSubscriptionsAvailable, this.subscriptionIdentifiersAvailable, this.responseInformation, this.serverReference, this.reasonString, this.userProperties);
    }
}

