/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.publish;

import com.google.common.primitives.ImmutableIntArray;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extension.sdk.api.packets.publish.PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.packets.publish.PublishPacket;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.mqtt.message.publish.PUBLISH;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PublishPacketImpl
implements PublishPacket {
    @NotNull
    final String topic;
    @NotNull
    final Qos qos;
    @NotNull
    final Qos onwardQos;
    final int packetId;
    final boolean dupFlag;
    @Nullable
    final ByteBuffer payload;
    final boolean retain;
    final long messageExpiryInterval;
    @Nullable
    final PayloadFormatIndicator payloadFormatIndicator;
    @Nullable
    final String contentType;
    @Nullable
    final String responseTopic;
    @Nullable
    final ByteBuffer correlationData;
    @NotNull
    final ImmutableIntArray subscriptionIdentifiers;
    @NotNull
    final UserPropertiesImpl userProperties;
    final long timestamp;

    public PublishPacketImpl(@NotNull String topic, @NotNull Qos qos, @NotNull Qos onwardQos, int packetId, boolean dupFlag, @Nullable ByteBuffer payload, boolean retain, long messageExpiryInterval, @Nullable PayloadFormatIndicator payloadFormatIndicator, @Nullable String contentType, @Nullable String responseTopic, @Nullable ByteBuffer correlationData, @NotNull ImmutableIntArray subscriptionIdentifiers, @NotNull UserPropertiesImpl userProperties, long timestamp) {
        this.topic = topic;
        this.qos = qos;
        this.onwardQos = onwardQos;
        this.packetId = packetId;
        this.dupFlag = dupFlag;
        this.payload = payload;
        this.retain = retain;
        this.messageExpiryInterval = messageExpiryInterval;
        this.payloadFormatIndicator = payloadFormatIndicator;
        this.contentType = contentType;
        this.responseTopic = responseTopic;
        this.correlationData = correlationData;
        this.subscriptionIdentifiers = subscriptionIdentifiers;
        this.userProperties = userProperties;
        this.timestamp = timestamp;
    }

    public PublishPacketImpl(@NotNull PUBLISH publish) {
        this(publish.getTopic(), publish.getQoS().toQos(), publish.getOnwardQoS().toQos(), publish.getPacketIdentifier(), publish.isDuplicateDelivery(), publish.getPayload() == null ? null : ByteBuffer.wrap(publish.getPayload()), publish.isRetain(), publish.getMessageExpiryInterval(), publish.getPayloadFormatIndicator() == null ? null : publish.getPayloadFormatIndicator().toPayloadFormatIndicator(), publish.getContentType(), publish.getResponseTopic(), publish.getCorrelationData() == null ? null : ByteBuffer.wrap(publish.getCorrelationData()), publish.getSubscriptionIdentifiers() == null ? ImmutableIntArray.of() : publish.getSubscriptionIdentifiers(), UserPropertiesImpl.of(publish.getUserProperties().asList()), publish.getTimestamp());
    }

    @NotNull
    public String getTopic() {
        return this.topic;
    }

    @NotNull
    public Qos getQos() {
        return this.qos;
    }

    @NotNull
    public Qos getOnwardQos() {
        return this.onwardQos;
    }

    public int getPacketId() {
        return this.packetId;
    }

    public boolean getDupFlag() {
        return this.dupFlag;
    }

    @NotNull
    public Optional<ByteBuffer> getPayload() {
        return this.payload == null ? Optional.empty() : Optional.of(this.payload.asReadOnlyBuffer());
    }

    public boolean getRetain() {
        return this.retain;
    }

    @NotNull
    public Optional<Long> getMessageExpiryInterval() {
        if (this.messageExpiryInterval == Long.MAX_VALUE) {
            return Optional.empty();
        }
        return Optional.of(this.messageExpiryInterval);
    }

    @NotNull
    public Optional<PayloadFormatIndicator> getPayloadFormatIndicator() {
        return Optional.ofNullable(this.payloadFormatIndicator);
    }

    @NotNull
    public Optional<String> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    @NotNull
    public Optional<String> getResponseTopic() {
        return Optional.ofNullable(this.responseTopic);
    }

    @NotNull
    public Optional<ByteBuffer> getCorrelationData() {
        return this.correlationData == null ? Optional.empty() : Optional.of(this.correlationData.asReadOnlyBuffer());
    }

    @NotNull
    public List<Integer> getSubscriptionIdentifiers() {
        return this.subscriptionIdentifiers.asList();
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishPacketImpl)) {
            return false;
        }
        PublishPacketImpl that = (PublishPacketImpl)o;
        return that.canEqual(this) && this.topic.equals(that.topic) && this.qos == that.qos && this.onwardQos == that.onwardQos && this.packetId == that.packetId && this.dupFlag == that.dupFlag && Objects.equals(this.payload, that.payload) && this.retain == that.retain && this.messageExpiryInterval == that.messageExpiryInterval && this.payloadFormatIndicator == that.payloadFormatIndicator && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.responseTopic, that.responseTopic) && Objects.equals(this.correlationData, that.correlationData) && this.subscriptionIdentifiers.equals((Object)that.subscriptionIdentifiers) && this.userProperties.equals(that.userProperties) && this.timestamp == that.timestamp;
    }

    protected boolean canEqual(@Nullable Object o) {
        return o instanceof PublishPacketImpl;
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.qos, this.onwardQos, this.packetId, this.dupFlag, this.payload, this.retain, this.messageExpiryInterval, this.payloadFormatIndicator, this.contentType, this.responseTopic, this.correlationData, this.subscriptionIdentifiers, this.userProperties, this.timestamp);
    }
}

