/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.pubrel;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.pubrel.PubrelPacket;
import com.hivemq.extension.sdk.api.packets.pubrel.PubrelReasonCode;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import com.hivemq.mqtt.message.reason.Mqtt5PubRelReasonCode;
import java.util.Objects;
import java.util.Optional;

public class PubrelPacketImpl
implements PubrelPacket {
    final int packetIdentifier;
    @NotNull
    final PubrelReasonCode reasonCode;
    @Nullable
    final String reasonString;
    @NotNull
    final UserPropertiesImpl userProperties;

    public PubrelPacketImpl(int packetIdentifier, @NotNull PubrelReasonCode reasonCode, @Nullable String reasonString, @NotNull UserPropertiesImpl userProperties) {
        this.packetIdentifier = packetIdentifier;
        this.reasonCode = reasonCode;
        this.reasonString = reasonString;
        this.userProperties = userProperties;
    }

    public PubrelPacketImpl(@NotNull PUBREL pubrel) {
        this(pubrel.getPacketIdentifier(), ((Mqtt5PubRelReasonCode)pubrel.getReasonCode()).toPubrelReasonCode(), pubrel.getReasonString(), UserPropertiesImpl.of(pubrel.getUserProperties().asList()));
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    @NotNull
    public PubrelReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PubrelPacketImpl)) {
            return false;
        }
        PubrelPacketImpl that = (PubrelPacketImpl)o;
        return this.packetIdentifier == that.packetIdentifier && this.reasonCode == that.reasonCode && Objects.equals(this.reasonString, that.reasonString) && this.userProperties.equals(that.userProperties);
    }

    public int hashCode() {
        return Objects.hash(this.packetIdentifier, this.reasonCode, this.reasonString, this.userProperties);
    }
}

