/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.auth;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.auth.Authenticator;
import com.hivemq.extension.sdk.api.auth.EnhancedAuthenticator;
import com.hivemq.extension.sdk.api.auth.SimpleAuthenticator;
import com.hivemq.extension.sdk.api.auth.parameter.AuthenticatorProviderInput;
import com.hivemq.extension.sdk.api.services.auth.provider.AuthenticatorProvider;
import com.hivemq.extension.sdk.api.services.auth.provider.EnhancedAuthenticatorProvider;
import com.hivemq.util.Exceptions;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappedAuthenticatorProvider {
    private static final Logger log = LoggerFactory.getLogger(WrappedAuthenticatorProvider.class);
    private static final String WRONG_CLASS_LOG_STATEMENT = "An extension provided an Authenticator instance of {} that was neither an implementation of SimpleAuthenticator nor EnhancedAuthenticator. The authenticator will be ignored.";
    private static final String UNCAUGHT_EXCEPTION_LOG_STATEMENT = "Uncaught exception was thrown in AuthenticatorProvider from extension. Extensions are responsible on their own to handle exceptions.";
    @Nullable
    private final AuthenticatorProvider simpleAuthenticatorProvider;
    @Nullable
    private final EnhancedAuthenticatorProvider enhancedAuthenticatorProvider;
    @NotNull
    private final ClassLoader classLoader;

    public WrappedAuthenticatorProvider(@NotNull AuthenticatorProvider simpleAuthenticatorProvider, @NotNull ClassLoader classLoader) {
        this.simpleAuthenticatorProvider = simpleAuthenticatorProvider;
        this.classLoader = classLoader;
        this.enhancedAuthenticatorProvider = null;
    }

    public WrappedAuthenticatorProvider(@NotNull EnhancedAuthenticatorProvider enhancedAuthenticatorProvider, @NotNull ClassLoader classLoader) {
        this.enhancedAuthenticatorProvider = enhancedAuthenticatorProvider;
        this.classLoader = classLoader;
        this.simpleAuthenticatorProvider = null;
    }

    @NotNull
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Nullable
    public SimpleAuthenticator getAuthenticator(@NotNull AuthenticatorProviderInput authenticatorProviderInput) {
        if (this.enhancedAuthenticatorProvider != null) {
            return null;
        }
        try {
            Authenticator authenticator = Objects.requireNonNull(this.simpleAuthenticatorProvider).getAuthenticator(authenticatorProviderInput);
            if (authenticator == null) {
                return null;
            }
            if (authenticator instanceof SimpleAuthenticator) {
                return (SimpleAuthenticator)authenticator;
            }
            log.warn(WRONG_CLASS_LOG_STATEMENT, authenticator.getClass());
            return null;
        }
        catch (Throwable throwable) {
            Exceptions.rethrowError(UNCAUGHT_EXCEPTION_LOG_STATEMENT, throwable);
            return null;
        }
    }

    @Nullable
    public EnhancedAuthenticator getEnhancedAuthenticator(@NotNull AuthenticatorProviderInput authenticatorProviderInput) {
        if (this.enhancedAuthenticatorProvider == null) {
            return null;
        }
        try {
            return Objects.requireNonNull(this.enhancedAuthenticatorProvider).getEnhancedAuthenticator(authenticatorProviderInput);
        }
        catch (Throwable throwable) {
            Exceptions.rethrowError(UNCAUGHT_EXCEPTION_LOG_STATEMENT, throwable);
            return null;
        }
    }

    public boolean isEnhanced() {
        return this.enhancedAuthenticatorProvider != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrappedAuthenticatorProvider that = (WrappedAuthenticatorProvider)o;
        return Objects.equals(this.classLoader, that.classLoader);
    }

    public int hashCode() {
        return Objects.hash(this.classLoader);
    }
}

