/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.builder;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.configuration.service.RestrictionsConfigurationService;
import com.hivemq.configuration.service.SecurityConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.auth.parameter.TopicPermission;
import com.hivemq.extension.sdk.api.services.builder.TopicPermissionBuilder;
import com.hivemq.extensions.auth.parameter.TopicPermissionImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import com.hivemq.util.Topics;

public class TopicPermissionBuilderImpl
implements TopicPermissionBuilder {
    @Nullable
    private String topicFilter = null;
    @NotNull
    private TopicPermission.PermissionType type = TopicPermission.PermissionType.ALLOW;
    @NotNull
    private TopicPermission.Qos qos = TopicPermission.Qos.ALL;
    @NotNull
    private TopicPermission.MqttActivity activity = TopicPermission.MqttActivity.ALL;
    @NotNull
    private TopicPermission.Retain retain = TopicPermission.Retain.ALL;
    @NotNull
    private TopicPermission.SharedSubscription sharedSubscription = TopicPermission.SharedSubscription.ALL;
    @NotNull
    private String sharedGroup = "#";
    @NotNull
    private final RestrictionsConfigurationService restrictionsConfig;
    @NotNull
    private final SecurityConfigurationService securityConfigurationService;

    @Inject
    public TopicPermissionBuilderImpl(@NotNull FullConfigurationService configurationService) {
        this.securityConfigurationService = configurationService.securityConfiguration();
        this.restrictionsConfig = configurationService.restrictionsConfiguration();
    }

    @NotNull
    public TopicPermissionBuilder topicFilter(@NotNull String topicFilter) {
        Preconditions.checkNotNull((Object)topicFilter, (Object)"Topic filter cannot be null");
        Preconditions.checkArgument((!topicFilter.isEmpty() ? 1 : 0) != 0, (Object)"Topic filter cannot be empty");
        Preconditions.checkArgument((topicFilter.length() <= this.restrictionsConfig.maxTopicLength() ? 1 : 0) != 0, (Object)("Topic filter length must not exceed '" + this.restrictionsConfig.maxTopicLength() + "' characters, but has '" + topicFilter.length() + "' characters"));
        Preconditions.checkArgument((boolean)Topics.isValidToSubscribe(topicFilter), (Object)"Topic filter is invalid");
        if (Topics.isSharedSubscriptionTopic(topicFilter)) {
            throw new IllegalArgumentException("Shared subscription topics are invalid, please use methods sharedSubscription and sharedGroup to apply permissions for shared subscriptions");
        }
        if (!PluginBuilderUtil.isValidUtf8String(topicFilter, this.securityConfigurationService.validateUTF8())) {
            throw new IllegalArgumentException("The topic filter (" + topicFilter + ") is UTF-8 malformed");
        }
        this.topicFilter = topicFilter;
        return this;
    }

    @NotNull
    public TopicPermissionBuilder type(@NotNull TopicPermission.PermissionType type) {
        Preconditions.checkNotNull((Object)type, (Object)"Type cannot be null");
        this.type = type;
        return this;
    }

    @NotNull
    public TopicPermissionBuilder qos(@NotNull TopicPermission.Qos qos) {
        Preconditions.checkNotNull((Object)qos, (Object)"QoS cannot be null");
        this.qos = qos;
        return this;
    }

    @NotNull
    public TopicPermissionBuilder activity(@NotNull TopicPermission.MqttActivity activity) {
        Preconditions.checkNotNull((Object)activity, (Object)"Activity cannot be null");
        this.activity = activity;
        return this;
    }

    @NotNull
    public TopicPermissionBuilder retain(@NotNull TopicPermission.Retain retain) {
        Preconditions.checkNotNull((Object)retain, (Object)"Retain cannot be null");
        this.retain = retain;
        return this;
    }

    @NotNull
    public TopicPermissionBuilder sharedSubscription(@NotNull TopicPermission.SharedSubscription sharedSubscription) {
        Preconditions.checkNotNull((Object)sharedSubscription, (Object)"Shared subscription cannot be null");
        this.sharedSubscription = sharedSubscription;
        return this;
    }

    @NotNull
    public TopicPermissionBuilder sharedGroup(@NotNull String sharedGroup) {
        Preconditions.checkNotNull((Object)sharedGroup, (Object)"Shared group cannot be null");
        Preconditions.checkArgument((!sharedGroup.isEmpty() ? 1 : 0) != 0, (Object)"Shared group cannot be empty");
        Preconditions.checkArgument((sharedGroup.length() <= 1 || !sharedGroup.contains("#") ? 1 : 0) != 0, (Object)"Shared group cannot contain wildcard character '#' inside the name");
        Preconditions.checkArgument((!sharedGroup.contains("+") ? 1 : 0) != 0, (Object)"Shared group cannot contain wildcard character '+'");
        Preconditions.checkArgument((!sharedGroup.contains("/") ? 1 : 0) != 0, (Object)"Shared group cannot contain character '/'");
        Preconditions.checkArgument((boolean)PluginBuilderUtil.isValidUtf8String(sharedGroup, this.securityConfigurationService.validateUTF8()), (Object)"Shared group contains invalid UTF-8 character");
        this.sharedGroup = sharedGroup;
        return this;
    }

    @NotNull
    public TopicPermission build() {
        Preconditions.checkNotNull((Object)this.topicFilter, (Object)"Topic filter must be set for a TopicPermission");
        return new TopicPermissionImpl(this.topicFilter, this.type, this.qos, this.activity, this.retain, this.sharedSubscription, this.sharedGroup);
    }
}

