/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.initializer;

import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extension.sdk.api.services.intializer.ClientInitializer;
import com.hivemq.extensions.ExtensionPriorityComparator;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.services.initializer.Initializers;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;

@LazySingleton
@ThreadSafe
public class InitializersImpl
implements Initializers {
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull ClientInitializer> clientInitializerMap;
    @NotNull
    private final ReadWriteLock readWriteLock;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;

    @Inject
    public InitializersImpl(@NotNull HiveMQExtensions hiveMQExtensions) {
        this.hiveMQExtensions = hiveMQExtensions;
        this.clientInitializerMap = new TreeMap<String, ClientInitializer>(new ExtensionPriorityComparator(hiveMQExtensions));
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientInitializer(@NotNull ClientInitializer initializer) {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            ClassLoader pluginClassloader = initializer.getClass().getClassLoader();
            HiveMQExtension plugin = this.hiveMQExtensions.getExtensionForClassloader(pluginClassloader);
            if (plugin != null) {
                this.clientInitializerMap.put(plugin.getId(), initializer);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull String, @NotNull ClientInitializer> getClientInitializerMap() {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            Map<String, ClientInitializer> map = this.clientInitializerMap;
            return map;
        }
        finally {
            readLock.unlock();
        }
    }
}

