/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.lifecycle;

import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.hivemq.bootstrap.ioc.SingletonModule;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.lifecycle.LifecycleRegistry;
import com.hivemq.lifecycle.LifecycleShutdownRegistration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleModule
extends SingletonModule<Class<LifecycleModule>> {
    private static final Logger log = LoggerFactory.getLogger(LifecycleModule.class);
    @NotNull
    private final LifecycleRegistry lifecycleRegistry = new LifecycleRegistry();

    public LifecycleModule() {
        super(LifecycleModule.class);
    }

    protected void configure() {
        this.bind(LifecycleRegistry.class).toInstance((Object)this.lifecycleRegistry);
        this.bind(LifecycleShutdownRegistration.class).asEagerSingleton();
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                LifecycleModule.this.executePostConstruct(encounter, type.getRawType());
            }
        });
    }

    private <I> void executePostConstruct(@NotNull TypeEncounter<I> encounter, @NotNull Class<? super I> rawType) {
        if (rawType.getSuperclass() != null) {
            this.executePostConstruct(encounter, rawType.getSuperclass());
        }
        boolean singleton = LifecycleModule.isSingleton(rawType);
        Method postConstructFound = LifecycleModule.findPostConstruct(rawType);
        Method preDestroy = LifecycleModule.findPreDestroy(rawType);
        if (singleton) {
            this.lifecycleRegistry.addSingletonClass(rawType);
        }
        if (postConstructFound != null && this.lifecycleRegistry.canInvokePostConstruct(rawType)) {
            LifecycleModule.invokePostConstruct(encounter, postConstructFound);
        }
        if (preDestroy != null && this.lifecycleRegistry.canInvokePreDestroy(rawType)) {
            LifecycleModule.addPreDestroyToRegistry(encounter, preDestroy, this.lifecycleRegistry);
        }
    }

    private static <I> boolean isSingleton(@NotNull Class<? super I> rawType) {
        return rawType.isAnnotationPresent(javax.inject.Singleton.class) || rawType.isAnnotationPresent(Singleton.class) || rawType.isAnnotationPresent(LazySingleton.class);
    }

    private static <I> Method findPostConstruct(@NotNull Class<? super I> rawType) {
        Method postConstructFound = null;
        for (Method method : rawType.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            if (method.getParameterTypes().length != 0) {
                throw new ProvisionException("A method annotated with @PostConstruct must not have any parameters");
            }
            if (method.getExceptionTypes().length > 0) {
                throw new ProvisionException("A method annotated with @PostConstruct must not throw any checked exceptions");
            }
            if (Modifier.isStatic(method.getModifiers())) {
                throw new ProvisionException("A method annotated with @PostConstruct must not be static");
            }
            if (postConstructFound != null) {
                throw new ProvisionException("More than one @PostConstruct method found for class " + rawType);
            }
            postConstructFound = method;
        }
        return postConstructFound;
    }

    private static <I> Method findPreDestroy(@NotNull Class<? super I> rawType) {
        Method predestroyFound = null;
        for (Method method : rawType.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PreDestroy.class)) continue;
            if (method.getParameterTypes().length != 0) {
                throw new ProvisionException("A method annotated with @PreDestroy must not have any parameters");
            }
            if (predestroyFound != null) {
                throw new ProvisionException("More than one @PreDestroy method found for class " + rawType);
            }
            predestroyFound = method;
        }
        return predestroyFound;
    }

    private static <I> void invokePostConstruct(@NotNull TypeEncounter<I> encounter, @NotNull Method postConstruct) {
        encounter.register(injectee -> {
            try {
                postConstruct.setAccessible(true);
                postConstruct.invoke(injectee, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                if (e.getCause() instanceof UnrecoverableException) {
                    if (((UnrecoverableException)e.getCause()).isShowException()) {
                        log.error("An unrecoverable Exception occurred. Exiting HiveMQ", (Throwable)e);
                    }
                    System.exit(1);
                }
                throw new ProvisionException("An error occurred while calling @PostConstruct", (Throwable)e);
            }
        });
    }

    private static <I> void addPreDestroyToRegistry(@NotNull TypeEncounter<I> encounter, @NotNull Method preDestroy, @NotNull LifecycleRegistry lifecycleRegistry) {
        encounter.register(injectionListener -> lifecycleRegistry.addPreDestroyMethod(preDestroy, injectionListener));
    }
}

