/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.lifecycle;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.util.ThreadFactoryUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LifecycleRegistry {
    private static final Logger log = LoggerFactory.getLogger(LifecycleRegistry.class);
    @NotNull
    private final Map<String, InvokeStatus> singletonClassInvokedStatusList = new ConcurrentHashMap<String, InvokeStatus>();
    @NotNull
    private final List<PreDestroyInvokable> preDestroyInvokables = Collections.synchronizedList(new ArrayList());
    @Nullable
    private ListeningExecutorService listeningExecutorService;

    LifecycleRegistry() {
    }

    public void shutdown() {
        if (this.listeningExecutorService != null) {
            this.listeningExecutorService.shutdown();
        }
    }

    public void addSingletonClass(@NotNull Class<?> clazz) {
        this.singletonClassInvokedStatusList.putIfAbsent(clazz.getCanonicalName(), new InvokeStatus());
    }

    public void addPreDestroyMethod(@NotNull Method preDestroyMethod, @NotNull Object onObject) {
        Preconditions.checkNotNull((Object)preDestroyMethod);
        Preconditions.checkNotNull((Object)onObject);
        this.preDestroyInvokables.add(new PreDestroyInvokable(preDestroyMethod, onObject));
    }

    public <T> boolean canInvokePostConstruct(@NotNull Class<T> clazz) {
        InvokeStatus invokeStatus = this.singletonClassInvokedStatusList.get(clazz.getCanonicalName());
        if (invokeStatus != null) {
            boolean postConstructed = invokeStatus.isPostConstructed();
            invokeStatus.setPostConstruct();
            return !postConstructed;
        }
        return true;
    }

    public <T> boolean canInvokePreDestroy(@NotNull Class<T> clazz) {
        InvokeStatus invokeStatus = this.singletonClassInvokedStatusList.get(clazz.getCanonicalName());
        if (invokeStatus != null) {
            boolean preDestroyed = invokeStatus.isPreDestroyed();
            invokeStatus.setPreDestroy();
            return !preDestroyed;
        }
        return true;
    }

    @NotNull
    public ListenableFuture<?> executePreDestroy() {
        ExecutorService executorService = Executors.newFixedThreadPool(3, ThreadFactoryUtil.create("PreDestroy-%d"));
        this.listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)executorService);
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(this.preDestroyInvokables.size());
        for (final PreDestroyInvokable preDestroyInvokable : this.preDestroyInvokables) {
            futures.add(this.listeningExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        preDestroyInvokable.getPreDestroyMethod().invoke(preDestroyInvokable.getOnObject(), new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        log.error("Could not execute preDestroy method for class {}", preDestroyInvokable.getOnObject().getClass(), (Object)e);
                    }
                }
            }));
        }
        return Futures.allAsList(futures);
    }

    private static final class PreDestroyInvokable {
        @NotNull
        private final Method preDestroyMethod;
        @NotNull
        private final Object onObject;

        public PreDestroyInvokable(@NotNull Method preDestroyMethod, @NotNull Object onObject) {
            this.preDestroyMethod = preDestroyMethod;
            this.onObject = onObject;
        }

        @NotNull
        public Method getPreDestroyMethod() {
            return this.preDestroyMethod;
        }

        @NotNull
        public Object getOnObject() {
            return this.onObject;
        }
    }

    private static final class InvokeStatus {
        private boolean postConstruct;
        private boolean preDestroy;

        private InvokeStatus() {
        }

        public boolean isPostConstructed() {
            return this.postConstruct;
        }

        public void setPostConstruct() {
            this.postConstruct = true;
        }

        public boolean isPreDestroyed() {
            return this.preDestroy;
        }

        public void setPreDestroy() {
            this.preDestroy = true;
        }
    }
}

