/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.logging;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.reason.Mqtt5AuthReasonCode;
import io.netty.channel.Channel;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class EventLog {
    private static final Logger log = LoggerFactory.getLogger(EventLog.class);
    public static final String EVENT_CLIENT_CONNECTED = "event.client-connected";
    public static final String EVENT_CLIENT_DISCONNECTED = "event.client-disconnected";
    public static final String EVENT_MESSAGE_DROPPED = "event.message-dropped";
    public static final String EVENT_CLIENT_SESSION_EXPIRED = "event.client-session-expired";
    public static final String EVENT_AUTHENTICATION = "event.authentication";
    private static final Logger logClientConnected = LoggerFactory.getLogger((String)"event.client-connected");
    private static final Logger logClientDisconnected = LoggerFactory.getLogger((String)"event.client-disconnected");
    private static final Logger logMessageDropped = LoggerFactory.getLogger((String)"event.message-dropped");
    private static final Logger logClientSessionExpired = LoggerFactory.getLogger((String)"event.client-session-expired");
    private static final Logger logAuthentication = LoggerFactory.getLogger((String)"event.authentication");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final ZoneId ZONE = ZoneId.of("UTC");

    public void messageDropped(@Nullable String clientId, @Nullable String topic, @NotNull int qos, @NotNull String reason) {
        logMessageDropped.debug("Outgoing publish message was dropped. Receiving client: {}, topic: {}, qos: {}, reason: {}.", new Object[]{this.valueOrUnknown(clientId), this.valueOrUnknown(topic), qos, reason});
    }

    public void sharedSubscriptionMessageDropped(@Nullable String group, @Nullable String topic, @NotNull int qos, @NotNull String reason) {
        logMessageDropped.debug("Outgoing publish message was dropped. Receiving shared subscription group: {}, topic: {}, qos: {}, reason: {}.", new Object[]{this.valueOrUnknown(group), this.valueOrUnknown(topic), qos, reason});
    }

    public void mqttMessageDropped(@Nullable String client, @Nullable String messageType, @NotNull String reason) {
        logMessageDropped.debug("Outgoing MQTT packet was dropped. Receiving client: {}, messageType: {}, reason: {}.", new Object[]{this.valueOrUnknown(client), this.valueOrUnknown(messageType), reason});
    }

    public void clientConnected(@NotNull Channel channel, boolean cleanStart) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        String clientId = clientConnectionContext.getClientId();
        String ip = clientConnectionContext.getChannelIP().orElse(null);
        Long sessionExpiry = clientConnectionContext.getClientSessionExpiryInterval();
        logClientConnected.debug("Client ID: {}, IP: {}, Clean Start: {}, Session Expiry: {} connected.", new Object[]{this.valueOrUnknown(clientId), this.valueOrUnknown(ip), this.valueOrUnknown(cleanStart), this.valueOrUnknown(sessionExpiry)});
    }

    public void clientDisconnectedGracefully(@NotNull ClientConnectionContext clientConnectionContext, @Nullable String reason) {
        String clientId = clientConnectionContext.getClientId();
        String ip = clientConnectionContext.getChannelIP().orElse(null);
        if (log.isTraceEnabled()) {
            log.trace("Client {} disconnected gracefully.", (Object)clientId);
        }
        if (reason != null) {
            logClientDisconnected.debug("Client ID: {}, IP: {} disconnected gracefully. Reason given by client: {}", new Object[]{this.valueOrUnknown(clientId), this.valueOrUnknown(ip), reason});
        } else {
            logClientDisconnected.debug("Client ID: {}, IP: {} disconnected gracefully.", (Object)this.valueOrUnknown(clientId), (Object)this.valueOrUnknown(ip));
        }
    }

    public void clientDisconnectedUngracefully(@NotNull ClientConnectionContext clientConnectionContext) {
        String clientId = clientConnectionContext.getClientId();
        String ip = clientConnectionContext.getChannelIP().orElse(null);
        Listener listener = clientConnectionContext.getConnectedListener();
        String listenerName = listener.readableName();
        int listenerPort = listener.getPort();
        String eventLogMessage = "Client ID: {}, IP: {} disconnected ungracefully from {} on port: {}.";
        if (log.isTraceEnabled()) {
            log.trace("Client {} disconnected ungracefully.", (Object)clientId);
        }
        logClientDisconnected.debug("Client ID: {}, IP: {} disconnected ungracefully from {} on port: {}.", new Object[]{this.valueOrUnknown(clientId), this.valueOrUnknown(ip), listenerName, listenerPort});
    }

    public void clientWasDisconnected(@NotNull Channel channel, @NotNull String reason) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        String clientId = clientConnectionContext.getClientId();
        String ip = clientConnectionContext.getChannelIP().orElse(null);
        if (log.isTraceEnabled()) {
            log.trace("Client {} was disconnected.", (Object)clientId);
        }
        logClientDisconnected.debug("Client ID: {}, IP: {} was disconnected. reason: {}.", new Object[]{this.valueOrUnknown(clientId), this.valueOrUnknown(ip), reason});
    }

    public void clientAuthentication(@NotNull Channel channel, @NotNull Mqtt5AuthReasonCode reasonCode, boolean received) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        String clientId = clientConnectionContext.getClientId();
        String ip = clientConnectionContext.getChannelIP().orElse(null);
        if (received) {
            logAuthentication.debug("Received AUTH from Client ID: {}, IP: {}, reason code: {}.", new Object[]{this.valueOrUnknown(clientId), this.valueOrUnknown(ip), reasonCode.name()});
        } else {
            logAuthentication.debug("Sent AUTH to Client ID: {}, IP: {}, reason code: {}.", new Object[]{this.valueOrUnknown(clientId), this.valueOrUnknown(ip), reasonCode.name()});
        }
    }

    public void clientSessionExpired(Long expiryTimestamp, @Nullable String clientId) {
        LocalDateTime disconnectedSinceDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(expiryTimestamp), ZONE);
        logClientSessionExpired.debug("Client ID: {} session has expired at {}. All persistent data for this client has been removed.", (Object)this.valueOrUnknown(clientId), (Object)disconnectedSinceDateTime.format(dateTimeFormatter));
    }

    @NotNull
    private String valueOrUnknown(@Nullable Object object) {
        return object != null ? object.toString() : "UNKNOWN";
    }
}

