/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.metrics.ioc.provider;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.hivemq.metrics.HiveMQMetrics;
import com.hivemq.metrics.gauges.RetainedMessagesGauge;
import com.hivemq.persistence.retained.RetainedMessagePersistence;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class RetainedMessagesGaugeProvider
implements Provider<RetainedMessagesGauge> {
    private final RetainedMessagePersistence retainedMessagePersistence;
    private final MetricRegistry metricRegistry;

    @Inject
    public RetainedMessagesGaugeProvider(RetainedMessagePersistence retainedMessagePersistence, MetricRegistry metricRegistry) {
        this.retainedMessagePersistence = retainedMessagePersistence;
        this.metricRegistry = metricRegistry;
    }

    @Singleton
    public RetainedMessagesGauge get() {
        RetainedMessagesGauge gauge = new RetainedMessagesGauge(this.retainedMessagePersistence);
        this.metricRegistry.register(HiveMQMetrics.RETAINED_MESSAGES_CURRENT.name(), (Metric)gauge);
        return gauge;
    }
}

