/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.metrics.jmx;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.google.common.annotations.VisibleForTesting;
import com.hivemq.configuration.service.InternalConfigurations;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JmxReporterBootstrap {
    private static final Logger log = LoggerFactory.getLogger(JmxReporterBootstrap.class);
    private final MetricRegistry metricRegistry;
    @VisibleForTesting
    JmxReporter jmxReporter;

    @Inject
    public JmxReporterBootstrap(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @PostConstruct
    public void postConstruct() {
        if (!InternalConfigurations.JMX_REPORTER_ENABLED.get()) {
            return;
        }
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).createsObjectNamesWith((type, domain, name) -> {
            try {
                ObjectName objectName = new ObjectName(domain, "name", name);
                if (objectName.isPattern()) {
                    objectName = new ObjectName(domain, "name", ObjectName.quote(name));
                }
                return objectName;
            }
            catch (MalformedObjectNameException e) {
                try {
                    return new ObjectName(domain, "name", ObjectName.quote(name));
                }
                catch (MalformedObjectNameException e1) {
                    log.warn("Unable to register {} {}", new Object[]{type, name, e1});
                    throw new RuntimeException(e1);
                }
            }
        }).build();
        this.jmxReporter.start();
        log.debug("Started JMX Metrics Reporting.");
    }

    public void stop() {
        if (this.jmxReporter != null) {
            this.jmxReporter.stop();
        }
    }
}

