/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.meta;

import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.meta.MetaInformation;
import com.hivemq.migration.meta.MetaInformationSerializer;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaFileService {
    private static final String META_FOLDER_NAME = "metadata";
    private static final String META_FILE_NAME = "versions.hmq";
    public static final MetaInformationSerializer serializer = new MetaInformationSerializer();
    private static final Logger log = LoggerFactory.getLogger(MetaFileService.class);
    private static final Logger migrationlog = LoggerFactory.getLogger((String)"migrations");

    @NotNull
    public static MetaInformation readMetaFile(@NotNull SystemInformation systemInformation) {
        File dataFolder = systemInformation.getDataFolder();
        MetaInformation metaInformation = new MetaInformation();
        if (!dataFolder.exists()) {
            return metaInformation;
        }
        metaInformation.setDataFolderPresent(true);
        File persistenceFolder = new File(dataFolder, "persistence");
        if (!persistenceFolder.exists()) {
            return metaInformation;
        }
        metaInformation.setPersistenceFolderPresent(true);
        File metaFile = MetaFileService.getMetaFile(systemInformation);
        if (!metaFile.exists()) {
            return metaInformation;
        }
        metaInformation.setMetaFilePresent(true);
        try {
            byte[] bytes = FileUtils.readFileToByteArray((File)metaFile);
            MetaInformation metaInfo = serializer.deserialize(bytes);
            migrationlog.info("Read metadata file: {}", (Object)metaInfo);
            return metaInfo;
        }
        catch (IOException e) {
            migrationlog.error("Not able to read metadata file", (Throwable)e);
            log.trace("Not able to read meta file", (Throwable)e);
            metaInformation.setMetaFilePresent(false);
            return metaInformation;
        }
    }

    public static void writeMetaFile(@NotNull SystemInformation systemInformation, @NotNull MetaInformation metaInformation) {
        File metaFile = MetaFileService.getMetaFile(systemInformation);
        try {
            FileUtils.writeByteArrayToFile((File)metaFile, (byte[])serializer.serialize(metaInformation), (boolean)false);
            migrationlog.info("Write metadata file: {}", (Object)metaInformation);
        }
        catch (IOException e) {
            migrationlog.error("Not able to write metadata file", (Throwable)e);
            log.error("Not able to write metadata file, please check your file and folder permissions");
            log.debug("Original exception", (Throwable)e);
        }
    }

    @NotNull
    private static File getMetaFile(SystemInformation systemInformation) {
        return new File(systemInformation.getDataFolder(), META_FOLDER_NAME + File.separator + META_FILE_NAME);
    }
}

