/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.persistence;

import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.MigrationUnit;
import com.hivemq.migration.TypeMigration;
import com.hivemq.migration.ValueMigration;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.migration.persistence.payload.PublishPayloadTypeMigration;
import com.hivemq.migration.persistence.queue.ClientQueuePayloadIDMigration;
import com.hivemq.migration.persistence.retained.RetainedMessagePayloadIDMigration;
import com.hivemq.migration.persistence.retained.RetainedMessageTypeMigration;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class PersistenceMigrator {
    private static final Logger log = LoggerFactory.getLogger(PersistenceMigrator.class);
    private static final Logger migrationlog = LoggerFactory.getLogger((String)"migrations");
    @NotNull
    private final Provider<PublishPayloadTypeMigration> publishPayloadMigrationProvider;
    @NotNull
    private final Provider<RetainedMessageTypeMigration> retainedMessageMigrationProvider;
    @NotNull
    private final Provider<RetainedMessagePayloadIDMigration> retainedMessagePayloadIDMigrationProvider;
    @NotNull
    private final Provider<ClientQueuePayloadIDMigration> clientQueuePayloadIDMigrationProvider;

    @Inject
    public PersistenceMigrator(@NotNull Provider<PublishPayloadTypeMigration> publishPayloadMigrationProvider, @NotNull Provider<RetainedMessageTypeMigration> retainedMessageMigrationProvider, @NotNull Provider<RetainedMessagePayloadIDMigration> retainedMessagePayloadIDMigrationProvider, @NotNull Provider<ClientQueuePayloadIDMigration> clientQueuePayloadIDMigrationProvider) {
        this.publishPayloadMigrationProvider = publishPayloadMigrationProvider;
        this.retainedMessageMigrationProvider = retainedMessageMigrationProvider;
        this.retainedMessagePayloadIDMigrationProvider = retainedMessagePayloadIDMigrationProvider;
        this.clientQueuePayloadIDMigrationProvider = clientQueuePayloadIDMigrationProvider;
    }

    public void migratePersistenceTypes(Map<MigrationUnit, PersistenceType> migrations) {
        long start = System.currentTimeMillis();
        migrationlog.info("Start File Persistence migration.");
        log.info("Migrating File Persistences (this can take a few minutes).");
        block4: for (Map.Entry<MigrationUnit, PersistenceType> migration : migrations.entrySet()) {
            TypeMigration migrator;
            MigrationUnit migrationUnit = migration.getKey();
            PersistenceType persistenceType = migration.getValue();
            switch (migrationUnit) {
                case FILE_PERSISTENCE_PUBLISH_PAYLOAD: {
                    migrator = (TypeMigration)this.publishPayloadMigrationProvider.get();
                    break;
                }
                case FILE_PERSISTENCE_RETAINED_MESSAGES: {
                    migrator = (TypeMigration)this.retainedMessageMigrationProvider.get();
                    break;
                }
                default: {
                    continue block4;
                }
            }
            long startOne = System.currentTimeMillis();
            migrationlog.info("Migrating {} to type {}.", (Object)migrationUnit, (Object)persistenceType);
            log.debug("Migrating {} to type {}.", (Object)migrationUnit, (Object)persistenceType);
            migrator.migrateToType(persistenceType);
            migrationlog.info("Migrated {} to type {} successfully in {} ms", new Object[]{migrationUnit, persistenceType, System.currentTimeMillis() - startOne});
            log.debug("Migrated {} to type {} successfully in {} ms", new Object[]{migrationUnit, persistenceType, System.currentTimeMillis() - startOne});
        }
        log.info("File Persistences successfully migrated in " + (System.currentTimeMillis() - start) + " ms");
        migrationlog.info("File Persistences successfully migrated in " + (System.currentTimeMillis() - start) + " ms");
    }

    public void closeAllLegacyPersistences() {
        ((RetainedMessagePayloadIDMigration)this.retainedMessagePayloadIDMigrationProvider.get()).closeLegacy();
        ((ClientQueuePayloadIDMigration)this.clientQueuePayloadIDMigrationProvider.get()).closeLegacy();
    }

    public void migratePersistenceValues(@NotNull Set<MigrationUnit> valueMigrations) {
        block4: for (MigrationUnit migrationUnit : valueMigrations) {
            ValueMigration migrator;
            switch (migrationUnit) {
                case PAYLOAD_ID_RETAINED_MESSAGES: {
                    migrator = (ValueMigration)this.retainedMessagePayloadIDMigrationProvider.get();
                    break;
                }
                case PAYLOAD_ID_CLIENT_QUEUE: {
                    migrator = (ValueMigration)this.clientQueuePayloadIDMigrationProvider.get();
                    break;
                }
                default: {
                    continue block4;
                }
            }
            long startOne = System.currentTimeMillis();
            migrationlog.info("Migrating {}.", (Object)migrationUnit);
            log.debug("Migrating {}.", (Object)migrationUnit);
            migrator.migrateToValue();
            migrationlog.info("Migrated {} successfully in {} ms", (Object)migrationUnit, (Object)(System.currentTimeMillis() - startOne));
            log.debug("Migrated {} successfully in {} ms", (Object)migrationUnit, (Object)(System.currentTimeMillis() - startOne));
        }
    }
}

