/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.persistence.legacy;

import com.google.common.base.Preconditions;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.persistence.legacy.RetainedMessageItemCallback_4_4;
import com.hivemq.migration.persistence.legacy.serializer.RetainedMessageDeserializer_4_4;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.RetainedMessage;
import com.hivemq.persistence.local.rocksdb.RocksDBLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadPersistence;
import com.hivemq.util.LocalPersistenceFileUtil;
import com.hivemq.util.ThreadPreConditions;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jetbrains.exodus.ExodusException;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class RetainedMessageRocksDBLocalPersistence_4_4
extends RocksDBLocalPersistence {
    private static final Logger log = LoggerFactory.getLogger(RetainedMessageRocksDBLocalPersistence_4_4.class);
    public static final String PERSISTENCE_NAME = "retained_messages";
    public static final String PERSISTENCE_VERSION = "040000_R";
    @NotNull
    private final PublishPayloadPersistence payloadPersistence;
    @NotNull
    private final AtomicLong retainMessageCounter = new AtomicLong(0L);

    @Inject
    public RetainedMessageRocksDBLocalPersistence_4_4(@NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull PublishPayloadPersistence payloadPersistence, @NotNull PersistenceStartup persistenceStartup) {
        super(localPersistenceFileUtil, persistenceStartup, InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get(), 32, 64, 32768, false);
        this.payloadPersistence = payloadPersistence;
    }

    @Override
    @NotNull
    protected String getName() {
        return PERSISTENCE_NAME;
    }

    @Override
    @NotNull
    protected String getVersion() {
        return PERSISTENCE_VERSION;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return log;
    }

    @Override
    @PostConstruct
    protected void postConstruct() {
        super.postConstruct();
    }

    @Override
    public void init() {
        try {
            for (RocksDB bucket : this.buckets) {
                try (RocksIterator iterator = bucket.newIterator();){
                    iterator.seekToFirst();
                    while (iterator.isValid()) {
                        this.retainMessageCounter.incrementAndGet();
                        iterator.next();
                    }
                }
            }
        }
        catch (ExodusException e) {
            log.error("An error occurred while preparing the Retained Message persistence.");
            log.debug("Original Exception:", (Throwable)e);
            throw new UnrecoverableException(false);
        }
    }

    public void put(@NotNull RetainedMessage retainedMessage, @NotNull String topic, int bucketIndex) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        Preconditions.checkNotNull((Object)retainedMessage, (Object)"Retained message must not be null");
        ThreadPreConditions.startsWith("single-writer");
        RocksDB bucket = this.buckets[bucketIndex];
        try {
            byte[] serializedTopic = RetainedMessageDeserializer_4_4.serializeKey(topic);
            byte[] valueAsBytes = bucket.get(serializedTopic);
            if (valueAsBytes != null) {
                RetainedMessage retainedMessageFromStore = RetainedMessageDeserializer_4_4.deserializeValue(valueAsBytes);
                log.trace("Replacing retained message for topic {}", (Object)topic);
                bucket.put(serializedTopic, RetainedMessageDeserializer_4_4.serializeValue(retainedMessage));
                this.payloadPersistence.decrementReferenceCounter(retainedMessageFromStore.getPublishId());
            } else {
                log.trace("Creating new retained message for topic {}", (Object)topic);
                bucket.put(serializedTopic, RetainedMessageDeserializer_4_4.serializeValue(retainedMessage));
                this.retainMessageCounter.incrementAndGet();
            }
        }
        catch (Exception e) {
            log.error("An error occurred while persisting a retained message.");
            log.debug("Original Exception:", (Throwable)e);
        }
    }

    public long size() {
        return this.retainMessageCounter.get();
    }

    public void iterate(@NotNull RetainedMessageItemCallback_4_4 callback) {
        for (RocksDB bucket : this.buckets) {
            try (RocksIterator iterator = bucket.newIterator();){
                iterator.seekToFirst();
                while (iterator.isValid()) {
                    RetainedMessage message = RetainedMessageDeserializer_4_4.deserializeValue(iterator.value());
                    String topic = RetainedMessageDeserializer_4_4.deserializeKey(iterator.key());
                    callback.onItem(topic, message);
                    iterator.next();
                }
            }
        }
    }
}

