/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler;

import com.google.common.annotations.VisibleForTesting;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.KeepAliveDisconnectService;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class KeepAliveDisconnectHandler
extends ChannelInboundHandlerAdapter {
    static final long MIN_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private static final byte NOT_INITIATED = 0;
    private static final byte INITIATED = 1;
    private static final byte DESTROYED = 2;
    private final long readerIdleTimeNanos;
    @Nullable
    private Future<?> timeoutTaskFuture;
    private long lastReadTime;
    private byte state = 0;
    private boolean reading;
    @NotNull
    private final KeepAliveDisconnectService keepAliveDisconnectService;

    public KeepAliveDisconnectHandler(long readerIdleTime, @NotNull TimeUnit unit, @NotNull KeepAliveDisconnectService keepAliveDisconnectService) {
        this.keepAliveDisconnectService = keepAliveDisconnectService;
        this.readerIdleTimeNanos = readerIdleTime <= 0L ? 0L : Math.max(unit.toNanos(readerIdleTime), MIN_TIMEOUT_NANOS);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            this.initialize(ctx.channel());
        }
    }

    public void handlerRemoved(@NotNull ChannelHandlerContext ctx) {
        this.destroy();
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive()) {
            this.initialize(ctx.channel());
        }
        super.channelRegistered(ctx);
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx.channel());
        super.channelActive(ctx);
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        super.channelInactive(ctx);
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
        if (this.readerIdleTimeNanos > 0L) {
            this.reading = true;
        }
        ctx.fireChannelRead(msg);
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        if (this.readerIdleTimeNanos > 0L && this.reading) {
            this.lastReadTime = this.ticksInNanos();
            this.reading = false;
        }
        ctx.fireChannelReadComplete();
    }

    @VisibleForTesting
    void initialize(@NotNull Channel channel) {
        if (this.state > 0) {
            return;
        }
        this.state = 1;
        this.lastReadTime = this.ticksInNanos();
        if (this.readerIdleTimeNanos > 0L) {
            this.timeoutTaskFuture = channel.eventLoop().schedule((Runnable)new ReaderIdleTimeoutTask(channel), this.readerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
    }

    @VisibleForTesting
    long ticksInNanos() {
        return System.nanoTime();
    }

    private void destroy() {
        this.state = (byte)2;
        if (this.timeoutTaskFuture != null) {
            this.timeoutTaskFuture.cancel(false);
            this.timeoutTaskFuture = null;
        }
    }

    @VisibleForTesting
    public long getReaderIdleTimeNanos() {
        return this.readerIdleTimeNanos;
    }

    public int getState() {
        return this.state;
    }

    public boolean isReading() {
        return this.reading;
    }

    class ReaderIdleTimeoutTask
    implements Runnable {
        @NotNull
        private final Channel channel;

        ReaderIdleTimeoutTask(Channel channel) {
            this.channel = channel;
        }

        @Override
        public void run() {
            long nextDelay = KeepAliveDisconnectHandler.this.readerIdleTimeNanos;
            try {
                if (!this.channel.isOpen()) {
                    return;
                }
                if (!KeepAliveDisconnectHandler.this.reading) {
                    nextDelay -= KeepAliveDisconnectHandler.this.ticksInNanos() - KeepAliveDisconnectHandler.this.lastReadTime;
                }
                if (nextDelay <= 0L) {
                    KeepAliveDisconnectHandler.this.keepAliveDisconnectService.submitKeepAliveDisconnect(this.channel);
                } else {
                    KeepAliveDisconnectHandler.this.timeoutTaskFuture = this.channel.eventLoop().schedule((Runnable)this, nextDelay, TimeUnit.NANOSECONDS);
                }
            }
            catch (Exception e) {
                KeepAliveDisconnectHandler.this.timeoutTaskFuture = this.channel.eventLoop().schedule((Runnable)this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }
}

