/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.mqtt5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.MessageWithID;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5ReasonCode;
import java.nio.charset.StandardCharsets;

public abstract class MqttMessageWithUserProperties
extends MessageWithID {
    @NotNull
    private Mqtt5UserProperties userProperties;
    protected int bufferSize = -1;
    protected int remainingLength = -1;
    protected int propertyLength = -1;
    protected int omittedProperties = -1;

    public MqttMessageWithUserProperties(@NotNull Mqtt5UserProperties userProperties) {
        Preconditions.checkNotNull((Object)userProperties, (Object)"User properties may never be null");
        this.userProperties = userProperties;
    }

    @NotNull
    public Mqtt5UserProperties getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(@NotNull Mqtt5UserProperties userProperties) {
        this.userProperties = userProperties;
    }

    @Override
    public void setEncodedLength(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public int getEncodedLength() {
        return this.bufferSize;
    }

    @Override
    public int getRemainingLength() {
        return this.remainingLength;
    }

    @Override
    public void setRemainingLength(int remainingLength) {
        this.remainingLength = remainingLength;
    }

    @Override
    public int getPropertyLength() {
        return this.propertyLength;
    }

    @Override
    public void setPropertyLength(int propertyLength) {
        this.propertyLength = propertyLength;
    }

    @Override
    public int getOmittedProperties() {
        return this.omittedProperties;
    }

    @Override
    public void setOmittedProperties(int omittedProperties) {
        this.omittedProperties = omittedProperties;
    }

    public static abstract class MqttMessageWithIdAndReasonCodes<R extends Mqtt5ReasonCode>
    extends MqttMessageWithReasonString {
        private final ImmutableList<R> reasonCodes;

        protected MqttMessageWithIdAndReasonCodes(int packetIdentifier, @NotNull ImmutableList<R> reasonCodes, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties) {
            super(reasonString, userProperties);
            this.packetIdentifier = packetIdentifier;
            this.reasonCodes = reasonCodes;
        }

        @Override
        public int getPacketIdentifier() {
            return this.packetIdentifier;
        }

        @NotNull
        public ImmutableList<R> getReasonCodes() {
            return this.reasonCodes;
        }
    }

    public static abstract class MqttMessageWithIdAndReasonCode<R extends Mqtt5ReasonCode>
    extends MqttMessageWithReasonCode<R> {
        protected MqttMessageWithIdAndReasonCode(int packetIdentifier, @NotNull R reasonCode, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties) {
            super(reasonCode, reasonString, userProperties);
            this.packetIdentifier = packetIdentifier;
        }

        @Override
        public int getPacketIdentifier() {
            return this.packetIdentifier;
        }
    }

    public static abstract class MqttMessageWithReasonCode<R extends Mqtt5ReasonCode>
    extends MqttMessageWithReasonString {
        @NotNull
        private final R reasonCode;

        protected MqttMessageWithReasonCode(@NotNull R reasonCode, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties) {
            super(reasonString, userProperties);
            Preconditions.checkNotNull(reasonCode, (Object)"A reason code may never be null");
            this.reasonCode = reasonCode;
        }

        @NotNull
        public R getReasonCode() {
            return this.reasonCode;
        }
    }

    public static abstract class MqttMessageWithReasonString
    extends MqttMessageWithUserProperties {
        private final String reasonString;

        protected MqttMessageWithReasonString(@Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties) {
            super(userProperties);
            if (reasonString != null) {
                Preconditions.checkArgument((reasonString.getBytes(StandardCharsets.UTF_8).length <= 65535 ? 1 : 0) != 0, (Object)"A reason string must never exceed 65535 bytes");
            }
            this.reasonString = reasonString;
        }

        @Nullable
        public String getReasonString() {
            return this.reasonString;
        }
    }
}

