/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.mqtt5;

import com.google.common.base.Preconditions;
import com.hivemq.codec.encoder.mqtt5.MqttBinaryData;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.UserProperty;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public class MqttUserProperty
implements UserProperty {
    @NotNull
    private final String name;
    @NotNull
    private final String value;

    public static MqttUserProperty of(@NotNull String name, @NotNull String value) {
        return new MqttUserProperty(name, value);
    }

    @Nullable
    public static MqttUserProperty decode(@NotNull ByteBuf in, boolean validateUTF8) {
        String name = MqttBinaryData.decodeString(in, validateUTF8);
        if (name == null) {
            return null;
        }
        String value = MqttBinaryData.decodeString(in, validateUTF8);
        if (value == null) {
            return null;
        }
        return new MqttUserProperty(name, value);
    }

    public MqttUserProperty(@NotNull String name, @NotNull String value) {
        Preconditions.checkArgument((name.getBytes(StandardCharsets.UTF_8).length <= 65535 ? 1 : 0) != 0, (Object)"A user property name must never exceed 65535 bytes");
        Preconditions.checkArgument((value.getBytes(StandardCharsets.UTF_8).length <= 65535 ? 1 : 0) != 0, (Object)"A user property value must never exceed 65535 bytes");
        this.name = name;
        this.value = value;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getValue() {
        return this.value;
    }

    void encode(@NotNull ByteBuf out) {
        out.writeByte(38);
        MqttBinaryData.encode(this.name, out);
        MqttBinaryData.encode(this.value, out);
    }

    int encodedLength() {
        return 1 + MqttBinaryData.encodedLength(this.name) + MqttBinaryData.encodedLength(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttUserProperty)) {
            return false;
        }
        MqttUserProperty that = (MqttUserProperty)o;
        return this.name.equals(that.name) && this.value.equals(that.value);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.value.hashCode();
    }

    @NotNull
    public String toString() {
        return "(" + this.name + ", " + this.value + ")";
    }
}

