/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.subscribe;

import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.packets.subscribe.SubscribePacketImpl;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttMessageWithUserProperties;
import com.hivemq.mqtt.message.subscribe.Mqtt3SUBSCRIBE;
import com.hivemq.mqtt.message.subscribe.Mqtt5SUBSCRIBE;
import com.hivemq.mqtt.message.subscribe.Topic;

public class SUBSCRIBE
extends MqttMessageWithUserProperties
implements Mqtt3SUBSCRIBE,
Mqtt5SUBSCRIBE {
    @NotNull
    private final ImmutableList<Topic> topics;
    private final int subscriptionIdentifier;

    public SUBSCRIBE(@NotNull Mqtt5UserProperties userProperties, @NotNull ImmutableList<Topic> topics, int packetIdentifier, int subscriptionIdentifier) {
        super(userProperties);
        this.topics = topics;
        this.subscriptionIdentifier = subscriptionIdentifier;
        super.setPacketIdentifier(packetIdentifier);
    }

    public SUBSCRIBE(@NotNull ImmutableList<Topic> topics, int packetIdentifier) {
        this(Mqtt5UserProperties.NO_USER_PROPERTIES, topics, packetIdentifier, -1);
    }

    public SUBSCRIBE(int packetIdentifier, Topic ... topics) {
        this(Mqtt5UserProperties.NO_USER_PROPERTIES, (ImmutableList<Topic>)ImmutableList.copyOf((Object[])topics), packetIdentifier, -1);
    }

    @NotNull
    public static SUBSCRIBE from(@NotNull SubscribePacketImpl packet) {
        ImmutableList.Builder subscriptionBuilder = ImmutableList.builder();
        packet.getSubscriptions().forEach(subscription -> subscriptionBuilder.add((Object)Topic.topicFromSubscription(subscription, packet.getSubscriptionIdentifier().orElse(null))));
        return new SUBSCRIBE(Mqtt5UserProperties.of(packet.getUserProperties().asInternalList()), (ImmutableList<Topic>)subscriptionBuilder.build(), packet.getPacketId(), packet.getSubscriptionIdentifier().orElse(-1));
    }

    @Override
    @NotNull
    public ImmutableList<Topic> getTopics() {
        return this.topics;
    }

    @Override
    public int getSubscriptionIdentifier() {
        return this.subscriptionIdentifier;
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.SUBSCRIBE;
    }
}

