/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.topic;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.ImmutableIntArray;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.topic.SubscriberWithQoS;
import com.hivemq.mqtt.topic.SubscriptionFlag;
import com.hivemq.util.Bytes;
import java.util.Objects;

public class SubscriberWithIdentifiers
implements Comparable<SubscriberWithIdentifiers> {
    @NotNull
    private final String subscriber;
    private int qos;
    private final byte flags;
    @Nullable
    private final String sharedName;
    @NotNull
    private ImmutableIntArray subscriptionIdentifiers;
    @Nullable
    private final String topicFilter;

    public SubscriberWithIdentifiers(@NotNull String subscriber, int qos, byte flags, @Nullable String sharedName) {
        Preconditions.checkNotNull((Object)subscriber, (Object)"Subscriber must not be null");
        this.subscriber = subscriber;
        this.qos = qos;
        this.flags = flags;
        this.sharedName = sharedName;
        this.subscriptionIdentifiers = ImmutableIntArray.of();
        this.topicFilter = null;
    }

    public SubscriberWithIdentifiers(@NotNull String subscriber, int qos, byte flags, @Nullable String sharedName, @NotNull ImmutableList<Integer> subscriptionIdentifier, @Nullable String topicFilter) {
        Preconditions.checkNotNull((Object)subscriber, (Object)"Subscriber must not be null");
        this.subscriber = subscriber;
        this.qos = qos;
        this.flags = flags;
        this.sharedName = sharedName;
        this.subscriptionIdentifiers = ImmutableIntArray.of();
        this.topicFilter = topicFilter;
    }

    public SubscriberWithIdentifiers(@NotNull SubscriberWithQoS subscriberWithQoS) {
        Preconditions.checkNotNull((Object)subscriberWithQoS, (Object)"Subscriber must not be null");
        this.subscriber = subscriberWithQoS.getSubscriber();
        this.qos = subscriberWithQoS.getQos();
        this.flags = subscriberWithQoS.getFlags();
        this.sharedName = subscriberWithQoS.getSharedName();
        Integer subscriptionIdentifiers = subscriberWithQoS.getSubscriptionIdentifier();
        this.subscriptionIdentifiers = subscriptionIdentifiers == null ? ImmutableIntArray.of() : ImmutableIntArray.of((int)subscriptionIdentifiers);
        this.topicFilter = subscriberWithQoS.getTopicFilter();
    }

    @Override
    public int compareTo(SubscriberWithIdentifiers o) {
        int subscriberCompare = this.subscriber.compareTo(o.getSubscriber());
        if (subscriberCompare == 0) {
            return Integer.compare(this.qos, o.getQos());
        }
        return subscriberCompare;
    }

    @NotNull
    public String getSubscriber() {
        return this.subscriber;
    }

    public int getQos() {
        return this.qos;
    }

    public byte getFlags() {
        return this.flags;
    }

    @Nullable
    public String getSharedName() {
        return this.sharedName;
    }

    @NotNull
    public ImmutableIntArray getSubscriptionIdentifier() {
        return this.subscriptionIdentifiers;
    }

    public void setSubscriptionIdentifiers(@NotNull ImmutableIntArray subscriptionIdentifiers) {
        this.subscriptionIdentifiers = subscriptionIdentifiers;
    }

    public void setQos(int qos) {
        this.qos = qos;
    }

    public boolean isSharedSubscription() {
        return Bytes.isBitSet(this.flags, SubscriptionFlag.SHARED_SUBSCRIPTION.getFlagIndex());
    }

    public boolean isRetainAsPublished() {
        return Bytes.isBitSet(this.flags, SubscriptionFlag.RETAIN_AS_PUBLISHED.getFlagIndex());
    }

    public boolean isNoLocal() {
        return Bytes.isBitSet(this.flags, SubscriptionFlag.NO_LOCAL.getFlagIndex());
    }

    @Nullable
    public String getTopicFilter() {
        return this.topicFilter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriberWithIdentifiers that = (SubscriberWithIdentifiers)o;
        return this.qos == that.qos && this.flags == that.flags && Objects.equals(this.subscriber, that.subscriber) && Objects.equals(this.sharedName, that.sharedName) && Objects.equals(this.subscriptionIdentifiers, that.subscriptionIdentifiers) && Objects.equals(this.topicFilter, that.topicFilter);
    }

    public int hashCode() {
        return Objects.hash(this.subscriber, this.qos, this.flags, this.sharedName, this.subscriptionIdentifiers, this.topicFilter);
    }
}

