/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.topic.tree;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.mqtt.topic.SubscriptionFlag;
import com.hivemq.mqtt.topic.tree.LocalTopicTree;
import com.hivemq.persistence.clientsession.ClientSession;
import com.hivemq.persistence.clientsession.ClientSessionPersistence;
import com.hivemq.persistence.clientsession.ClientSessionSubscriptionPersistence;
import com.hivemq.persistence.clientsession.SharedSubscriptionService;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TopicTreeStartup {
    private static final Logger log = LoggerFactory.getLogger(TopicTreeStartup.class);
    @NotNull
    private final LocalTopicTree topicTree;
    @NotNull
    private final ClientSessionPersistence clientSessionPersistence;
    @NotNull
    private final ClientSessionSubscriptionPersistence clientSessionSubscriptionPersistence;
    @NotNull
    private final SharedSubscriptionService sharedSubscriptionService;

    @Inject
    TopicTreeStartup(@NotNull LocalTopicTree topicTree, @NotNull ClientSessionPersistence clientSessionPersistence, @NotNull ClientSessionSubscriptionPersistence clientSessionSubscriptionPersistence, @NotNull SharedSubscriptionService sharedSubscriptionService) {
        this.topicTree = topicTree;
        this.clientSessionPersistence = clientSessionPersistence;
        this.clientSessionSubscriptionPersistence = clientSessionSubscriptionPersistence;
        this.sharedSubscriptionService = sharedSubscriptionService;
    }

    @PostConstruct
    void postConstruct() {
        log.debug("Building initial topic tree");
        this.populateTopicTree();
    }

    private void populateTopicTree() {
        ListenableFuture<Set<String>> clientsFuture = this.clientSessionPersistence.getAllClients();
        try {
            Set clients = (Set)clientsFuture.get();
            for (String client : clients) {
                ImmutableSet<Topic> clientSubscriptions = this.clientSessionSubscriptionPersistence.getSubscriptions(client);
                ClientSession session = this.clientSessionPersistence.getSession(client, false);
                if (session == null || session.getSessionExpiryIntervalSec() == 0L) {
                    this.clientSessionSubscriptionPersistence.removeAllLocally(client);
                    continue;
                }
                for (Topic topic : clientSubscriptions) {
                    byte flags;
                    SharedSubscriptionService.SharedSubscription sharedSubscription = SharedSubscriptionService.checkForSharedSubscription(topic.getTopic());
                    if (sharedSubscription == null) {
                        flags = SubscriptionFlag.getDefaultFlags(false, topic.isRetainAsPublished(), topic.isNoLocal());
                        this.topicTree.addTopic(client, topic, flags, null);
                        continue;
                    }
                    flags = SubscriptionFlag.getDefaultFlags(true, topic.isRetainAsPublished(), topic.isNoLocal());
                    Topic sharedTopic = new Topic(sharedSubscription.getTopicFilter(), topic.getQoS(), topic.isNoLocal(), topic.isRetainAsPublished());
                    this.topicTree.addTopic(client, sharedTopic, flags, sharedSubscription.getShareName());
                }
            }
        }
        catch (Exception ex) {
            log.error("Failed to bootstrap topic tree.", (Throwable)ex);
        }
    }
}

