/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence;

import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.FilePersistence;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PersistenceStartup
implements HiveMQShutdownHook {
    private static final Logger log = LoggerFactory.getLogger(PersistenceStartup.class);
    private static final int FILE_PERSISTENCE_COUNT = 5;
    @NotNull
    private final ExecutorService persistenceStartExecutor = Executors.newFixedThreadPool(5);
    @NotNull
    private final ExecutorService environmentCreateExecutor = Executors.newFixedThreadPool(InternalConfigurations.PERSISTENCE_STARTUP_THREAD_POOL_SIZE.get());
    @NotNull
    private final List<FilePersistence> filePersistenceList = new ArrayList<FilePersistence>(5);
    private final long start = System.currentTimeMillis();

    public void submitEnvironmentCreate(@NotNull Runnable createTask) {
        this.environmentCreateExecutor.submit(createTask);
    }

    public void submitPersistenceStart(@NotNull FilePersistence filePersistence) {
        this.filePersistenceList.add(filePersistence);
        this.persistenceStartExecutor.submit(filePersistence::start);
    }

    public void finish() throws InterruptedException {
        log.trace("Waiting for persistence start execution");
        this.persistenceStartExecutor.shutdown();
        while (!this.persistenceStartExecutor.awaitTermination(20L, TimeUnit.SECONDS)) {
            log.trace("Waiting for persistence start execution");
        }
        log.trace("Waiting for environment create execution");
        this.environmentCreateExecutor.shutdown();
        while (!this.environmentCreateExecutor.awaitTermination(20L, TimeUnit.SECONDS)) {
            log.trace("Waiting for environment create execution");
        }
        log.trace("Initialized persistences in {}ms", (Object)(System.currentTimeMillis() - this.start));
    }

    @Override
    @NotNull
    public String name() {
        return "PersistenceStartupShutdownHook";
    }

    @Override
    public void run() {
        log.trace("Shutting down persistence startup executors");
        this.persistenceStartExecutor.shutdown();
        this.environmentCreateExecutor.shutdown();
        try {
            if (!this.persistenceStartExecutor.awaitTermination(InternalConfigurations.PERSISTENCE_STARTUP_SHUTDOWN_TIMEOUT_SEC.get(), TimeUnit.SECONDS)) {
                this.persistenceStartExecutor.shutdownNow();
            }
            if (!this.environmentCreateExecutor.awaitTermination(InternalConfigurations.PERSISTENCE_STARTUP_SHUTDOWN_TIMEOUT_SEC.get(), TimeUnit.SECONDS)) {
                this.environmentCreateExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.persistenceStartExecutor.shutdownNow();
            this.environmentCreateExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        try {
            log.debug("Closing file persistences");
            for (FilePersistence filePersistence : this.filePersistenceList) {
                filePersistence.stop();
            }
        }
        catch (Throwable e) {
            log.error("Closing file persistence failed", e);
        }
    }
}

