/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.ioc;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.hivemq.bootstrap.ioc.SingletonModule;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.PersistenceConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.clientqueue.ClientQueuePersistence;
import com.hivemq.persistence.clientqueue.ClientQueuePersistenceImpl;
import com.hivemq.persistence.clientsession.ClientSessionPersistence;
import com.hivemq.persistence.clientsession.ClientSessionPersistenceProvider;
import com.hivemq.persistence.clientsession.ClientSessionSubscriptionPersistence;
import com.hivemq.persistence.clientsession.ClientSessionSubscriptionPersistenceProvider;
import com.hivemq.persistence.connection.ConnectionPersistence;
import com.hivemq.persistence.connection.ConnectionPersistenceImpl;
import com.hivemq.persistence.ioc.LocalPersistenceFileModule;
import com.hivemq.persistence.ioc.LocalPersistenceMemoryModule;
import com.hivemq.persistence.ioc.provider.local.IncomingMessageFlowPersistenceLocalProvider;
import com.hivemq.persistence.local.IncomingMessageFlowLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadNoopPersistenceImpl;
import com.hivemq.persistence.payload.PublishPayloadPersistence;
import com.hivemq.persistence.payload.PublishPayloadPersistenceImpl;
import com.hivemq.persistence.qos.IncomingMessageFlowPersistence;
import com.hivemq.persistence.qos.IncomingMessageFlowPersistenceImpl;
import com.hivemq.persistence.retained.RetainedMessagePersistence;
import com.hivemq.persistence.retained.RetainedMessagePersistenceProvider;
import javax.inject.Singleton;

class LocalPersistenceModule
extends SingletonModule<Class<LocalPersistenceModule>> {
    @NotNull
    private final Injector persistenceInjector;
    @NotNull
    private final PersistenceConfigurationService persistenceConfigurationService;

    public LocalPersistenceModule(@NotNull Injector persistenceInjector, @NotNull PersistenceConfigurationService persistenceConfigurationService) {
        super(LocalPersistenceModule.class);
        this.persistenceInjector = persistenceInjector;
        this.persistenceConfigurationService = persistenceConfigurationService;
    }

    protected void configure() {
        if (this.persistenceConfigurationService.getMode() == PersistenceConfigurationService.PersistenceMode.FILE) {
            this.install((Module)new LocalPersistenceFileModule(this.persistenceInjector));
        } else {
            this.install((Module)new LocalPersistenceMemoryModule(this.persistenceInjector));
        }
        this.bind(RetainedMessagePersistence.class).toProvider(RetainedMessagePersistenceProvider.class).in(LazySingleton.class);
        this.bind(ConnectionPersistence.class).to(ConnectionPersistenceImpl.class).in(Singleton.class);
        this.bind(ClientSessionPersistence.class).toProvider(ClientSessionPersistenceProvider.class).in(LazySingleton.class);
        this.bind(ClientSessionSubscriptionPersistence.class).toProvider(ClientSessionSubscriptionPersistenceProvider.class).in(LazySingleton.class);
        this.bind(IncomingMessageFlowPersistence.class).to(IncomingMessageFlowPersistenceImpl.class);
        this.bind(IncomingMessageFlowLocalPersistence.class).toProvider(IncomingMessageFlowPersistenceLocalProvider.class).in(LazySingleton.class);
        this.bind(ClientQueuePersistence.class).to(ClientQueuePersistenceImpl.class).in(LazySingleton.class);
        if (this.persistenceConfigurationService.getMode() == PersistenceConfigurationService.PersistenceMode.IN_MEMORY) {
            this.bind(PublishPayloadPersistence.class).toInstance((Object)((PublishPayloadPersistence)this.persistenceInjector.getInstance(PublishPayloadNoopPersistenceImpl.class)));
        } else {
            this.bind(PublishPayloadPersistence.class).toInstance((Object)((PublishPayloadPersistence)this.persistenceInjector.getInstance(PublishPayloadPersistence.class)));
            this.bind(PublishPayloadPersistenceImpl.class).toInstance((Object)((PublishPayloadPersistenceImpl)this.persistenceInjector.getInstance(PublishPayloadPersistenceImpl.class)));
        }
        this.bind(PersistenceStartup.class).toInstance((Object)((PersistenceStartup)this.persistenceInjector.getInstance(PersistenceStartup.class)));
    }
}

