/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.ioc;

import com.google.inject.Injector;
import com.hivemq.bootstrap.ioc.SingletonModule;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.persistence.local.xodus.RetainedMessageRocksDBLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadRocksDBLocalPersistence;
import com.hivemq.persistence.retained.RetainedMessageLocalPersistence;
import javax.inject.Singleton;

class LocalPersistenceRocksDBModule
extends SingletonModule<Class<LocalPersistenceRocksDBModule>> {
    private final Injector persistenceInjector;
    private final PersistenceType payloadPersistenceType;
    private final PersistenceType retainedPersistenceType;

    LocalPersistenceRocksDBModule(@NotNull Injector persistenceInjector) {
        super(LocalPersistenceRocksDBModule.class);
        this.persistenceInjector = persistenceInjector;
        this.payloadPersistenceType = InternalConfigurations.PAYLOAD_PERSISTENCE_TYPE.get();
        this.retainedPersistenceType = InternalConfigurations.RETAINED_MESSAGE_PERSISTENCE_TYPE.get();
    }

    protected void configure() {
        if (this.retainedPersistenceType == PersistenceType.FILE_NATIVE) {
            this.bindLocalPersistence(RetainedMessageLocalPersistence.class, RetainedMessageRocksDBLocalPersistence.class, null);
        }
        if (this.payloadPersistenceType == PersistenceType.FILE_NATIVE) {
            this.bindLocalPersistence(PublishPayloadLocalPersistence.class, PublishPayloadRocksDBLocalPersistence.class, null);
        }
    }

    private void bindLocalPersistence(@NotNull Class localPersistenceClass, @NotNull Class filePersistenceClass, @Nullable Class localPersistenceProviderClass) {
        Object instance = this.persistenceInjector.getInstance(filePersistenceClass);
        if (instance != null) {
            this.bind(filePersistenceClass).toInstance(instance);
            this.bind(localPersistenceClass).toInstance(instance);
        } else if (localPersistenceProviderClass != null) {
            this.bind(localPersistenceClass).toProvider(localPersistenceProviderClass).in(Singleton.class);
        }
    }
}

