/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.ioc;

import com.google.inject.Module;
import com.hivemq.bootstrap.ioc.SingletonModule;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.persistence.clientqueue.ClientQueueLocalPersistence;
import com.hivemq.persistence.clientqueue.ClientQueueXodusLocalPersistence;
import com.hivemq.persistence.ioc.PersistenceMigrationRocksDBModule;
import com.hivemq.persistence.ioc.provider.local.ClientSessionLocalProvider;
import com.hivemq.persistence.ioc.provider.local.ClientSessionSubscriptionLocalProvider;
import com.hivemq.persistence.local.ClientSessionLocalPersistence;
import com.hivemq.persistence.local.ClientSessionSubscriptionLocalPersistence;
import com.hivemq.persistence.local.xodus.RetainedMessageXodusLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadXodusLocalPersistence;
import com.hivemq.persistence.retained.RetainedMessageLocalPersistence;
import javax.inject.Singleton;

public class PersistenceMigrationFileModule
extends SingletonModule<Class<PersistenceMigrationFileModule>> {
    @NotNull
    private final PersistenceType payloadPersistenceType = InternalConfigurations.PAYLOAD_PERSISTENCE_TYPE.get();
    @NotNull
    private final PersistenceType retainedPersistenceType = InternalConfigurations.RETAINED_MESSAGE_PERSISTENCE_TYPE.get();

    public PersistenceMigrationFileModule() {
        super(PersistenceMigrationFileModule.class);
    }

    protected void configure() {
        if (this.retainedPersistenceType == PersistenceType.FILE) {
            this.bind(RetainedMessageLocalPersistence.class).to(RetainedMessageXodusLocalPersistence.class).in(Singleton.class);
        }
        if (this.payloadPersistenceType == PersistenceType.FILE) {
            this.bind(PublishPayloadLocalPersistence.class).to(PublishPayloadXodusLocalPersistence.class).in(Singleton.class);
        }
        if (this.retainedPersistenceType == PersistenceType.FILE_NATIVE || this.payloadPersistenceType == PersistenceType.FILE_NATIVE) {
            this.install((Module)new PersistenceMigrationRocksDBModule());
        }
        this.bind(ClientSessionLocalPersistence.class).toProvider(ClientSessionLocalProvider.class).in(Singleton.class);
        this.bind(ClientSessionSubscriptionLocalPersistence.class).toProvider(ClientSessionSubscriptionLocalProvider.class).in(Singleton.class);
        this.bind(ClientQueueLocalPersistence.class).to(ClientQueueXodusLocalPersistence.class).in(Singleton.class);
    }
}

