/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.memory;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.hivemq.annotations.ExecuteInSingleWriter;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.iteration.BucketChunkResult;
import com.hivemq.metrics.HiveMQMetrics;
import com.hivemq.persistence.RetainedMessage;
import com.hivemq.persistence.local.xodus.PublishTopicTree;
import com.hivemq.persistence.retained.RetainedMessageLocalPersistence;
import com.hivemq.util.ThreadPreConditions;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RetainedMessageMemoryLocalPersistence
implements RetainedMessageLocalPersistence {
    @VisibleForTesting
    @NotNull
    final AtomicLong currentMemorySize = new AtomicLong();
    @VisibleForTesting
    @NotNull
    final @NotNull PublishTopicTree @NotNull [] topicTrees;
    @NotNull
    private final Map<String, RetainedMessage>[] buckets;
    private final int bucketCount = InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get();

    @Inject
    public RetainedMessageMemoryLocalPersistence(@NotNull MetricRegistry metricRegistry) {
        int i;
        this.buckets = new HashMap[this.bucketCount];
        for (i = 0; i < this.bucketCount; ++i) {
            this.buckets[i] = new HashMap<String, RetainedMessage>();
        }
        this.topicTrees = new PublishTopicTree[this.bucketCount];
        for (i = 0; i < this.bucketCount; ++i) {
            this.topicTrees[i] = new PublishTopicTree();
        }
        metricRegistry.register(HiveMQMetrics.RETAINED_MESSAGES_MEMORY_PERSISTENCE_TOTAL_SIZE.name(), (Metric)((Gauge)this.currentMemorySize::get));
    }

    @Override
    public long size() {
        int sum = 0;
        for (Map<String, RetainedMessage> bucket : this.buckets) {
            sum += bucket.size();
        }
        return sum;
    }

    @Override
    @ExecuteInSingleWriter
    public void clear(int bucketIndex) {
        ThreadPreConditions.startsWith("single-writer");
        this.topicTrees[bucketIndex] = new PublishTopicTree();
        Map<String, RetainedMessage> bucket = this.buckets[bucketIndex];
        for (RetainedMessage retainedMessage : bucket.values()) {
            this.currentMemorySize.addAndGet(-retainedMessage.getEstimatedSizeInMemory());
        }
        bucket.clear();
    }

    @Override
    @ExecuteInSingleWriter
    public void remove(@NotNull String topic, int bucketIndex) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        ThreadPreConditions.startsWith("single-writer");
        this.topicTrees[bucketIndex].remove(topic);
        Map<String, RetainedMessage> bucket = this.buckets[bucketIndex];
        RetainedMessage retainedMessage = bucket.remove(topic);
        if (retainedMessage != null) {
            this.currentMemorySize.addAndGet(-retainedMessage.getEstimatedSizeInMemory());
        }
    }

    @Override
    @ExecuteInSingleWriter
    @Nullable
    public RetainedMessage get(@NotNull String topic, int bucketIndex) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, RetainedMessage> bucket = this.buckets[bucketIndex];
        RetainedMessage retainedMessage = bucket.get(topic);
        if (retainedMessage == null || retainedMessage.hasExpired()) {
            return null;
        }
        return retainedMessage;
    }

    @Override
    @ExecuteInSingleWriter
    public void put(@NotNull RetainedMessage retainedMessage, @NotNull String topic, int bucketIndex) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        Preconditions.checkNotNull((Object)retainedMessage, (Object)"Retained message must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, RetainedMessage> bucket = this.buckets[bucketIndex];
        RetainedMessage previousMessage = bucket.put(topic, retainedMessage);
        if (previousMessage != null) {
            this.currentMemorySize.addAndGet(-previousMessage.getEstimatedSizeInMemory());
        }
        this.currentMemorySize.addAndGet(retainedMessage.getEstimatedSizeInMemory());
        this.topicTrees[bucketIndex].add(topic);
    }

    @Override
    @ExecuteInSingleWriter
    @NotNull
    public Set<String> getAllTopics(@NotNull String subscription, int bucketIndex) {
        Preconditions.checkArgument((bucketIndex >= 0 && bucketIndex < this.bucketCount ? 1 : 0) != 0, (Object)"Bucket index out of range");
        ThreadPreConditions.startsWith("single-writer");
        return this.topicTrees[bucketIndex].get(subscription);
    }

    @Override
    @ExecuteInSingleWriter
    public void cleanUp(int bucketIndex) {
        Preconditions.checkArgument((bucketIndex >= 0 && bucketIndex < this.bucketCount ? 1 : 0) != 0, (Object)"Bucket index out of range");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, RetainedMessage> bucket = this.buckets[bucketIndex];
        bucket.entrySet().removeIf(entry -> {
            if (entry == null) {
                return false;
            }
            RetainedMessage retainedMessage = (RetainedMessage)entry.getValue();
            String topic = (String)entry.getKey();
            if (retainedMessage.hasExpired()) {
                this.currentMemorySize.addAndGet(-retainedMessage.getEstimatedSizeInMemory());
                this.topicTrees[bucketIndex].remove(topic);
                return true;
            }
            return false;
        });
    }

    @Override
    @NotNull
    public @NotNull BucketChunkResult<Map<String, @NotNull RetainedMessage>> getAllRetainedMessagesChunk(int bucketIndex, @Nullable String ignored, int alsoIgnored) {
        ImmutableMap collectedRetainedMessages = (ImmutableMap)this.buckets[bucketIndex].entrySet().stream().map(entry -> {
            String topic = (String)entry.getKey();
            RetainedMessage retainedMessage = (RetainedMessage)entry.getValue();
            if (retainedMessage.hasExpired()) {
                return null;
            }
            return new AbstractMap.SimpleEntry<String, RetainedMessage>(topic, retainedMessage);
        }).filter(entry -> !Objects.isNull(entry)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return new BucketChunkResult<ImmutableMap>(collectedRetainedMessages, true, null, bucketIndex);
    }

    @Override
    public void iterate(@NotNull RetainedMessageLocalPersistence.ItemCallback callback) {
        throw new UnsupportedOperationException("Iterate is only used for migrations which are not needed for memory persistences");
    }

    @Override
    public void closeDB(int bucketIndex) {
    }
}

