/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.payload;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BucketLock {
    private final Lock @NotNull [] locks;

    public BucketLock(int bucketCount) {
        this.locks = new Lock[bucketCount];
        for (int i = 0; i < bucketCount; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    public int getBucketCount() {
        return this.locks.length;
    }

    public void accessBucketByPayloadId(long payloadId, @NotNull BucketAccessCallback callback) {
        int index = BucketUtils.getBucket(Long.toString(payloadId), this.locks.length);
        this.accessBucket(index, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessBucket(int index, @NotNull BucketAccessCallback callback) {
        Lock lock = this.locks[index];
        lock.lock();
        try {
            callback.call(index);
        }
        finally {
            lock.unlock();
        }
    }

    @FunctionalInterface
    static interface BucketAccessCallback {
        public void call(int var1);
    }
}

