/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.payload;

import com.google.common.collect.ImmutableMap;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import com.hivemq.persistence.payload.BucketLock;
import com.hivemq.persistence.payload.PayloadReferenceCounterRegistry;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.collections.api.tuple.primitive.LongIntPair;
import org.eclipse.collections.impl.map.mutable.primitive.LongIntHashMap;

@NotThreadSafe
public class PayloadReferenceCounterRegistryImpl
implements PayloadReferenceCounterRegistry {
    @NotNull
    private final BucketLock bucketLock;
    @NotNull
    private final @NotNull LongIntHashMap @NotNull [] buckets;

    PayloadReferenceCounterRegistryImpl(@NotNull BucketLock bucketLock) {
        this.bucketLock = bucketLock;
        this.buckets = new LongIntHashMap[bucketLock.getBucketCount()];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new LongIntHashMap();
        }
    }

    @Override
    public int get(long payloadId) {
        LongIntHashMap map = this.buckets[this.bucketIndexForPayloadId(payloadId)];
        return map.getIfAbsent(payloadId, -1);
    }

    @Override
    public int getAndIncrement(long payloadId) {
        LongIntHashMap map = this.buckets[this.bucketIndexForPayloadId(payloadId)];
        int previousValue = map.getIfAbsent(payloadId, -1);
        if (previousValue == -1) {
            map.put(payloadId, 1);
        } else {
            map.put(payloadId, previousValue + 1);
        }
        return previousValue;
    }

    @Override
    public int decrementAndGet(long payloadId) {
        int bucketIndex = this.bucketIndexForPayloadId(payloadId);
        LongIntHashMap map = this.buckets[bucketIndex];
        int currentValue = map.getIfAbsent(payloadId, -1);
        if (currentValue == -1) {
            return -1;
        }
        if (currentValue == 0) {
            return -2;
        }
        int newValue = currentValue - 1;
        map.put(payloadId, newValue);
        return newValue;
    }

    @Override
    public void delete(long payloadId) {
        LongIntHashMap map = this.buckets[this.bucketIndexForPayloadId(payloadId)];
        if (map == null) {
            return;
        }
        map.remove(payloadId);
    }

    @Override
    @ThreadSafe
    @NotNull
    public ImmutableMap<Long, Integer> getAll() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < this.buckets.length; ++i) {
            this.bucketLock.accessBucket(i, bucketIndex -> {
                for (LongIntPair longIntPair : this.buckets[bucketIndex].keyValuesView()) {
                    builder.put((Object)longIntPair.getOne(), (Object)longIntPair.getTwo());
                }
            });
        }
        return builder.build();
    }

    @Override
    @ThreadSafe
    public int size() {
        AtomicInteger sum = new AtomicInteger();
        for (int i = 0; i < this.buckets.length; ++i) {
            this.bucketLock.accessBucket(i, bucketIndex -> sum.addAndGet(this.buckets[bucketIndex].size()));
        }
        return sum.get();
    }

    private int bucketIndexForPayloadId(long payloadId) {
        return BucketUtils.getBucket(Long.toString(payloadId), this.buckets.length);
    }
}

