/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.payload;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.local.xodus.EnvironmentUtil;
import com.hivemq.persistence.local.xodus.XodusLocalPersistence;
import com.hivemq.persistence.local.xodus.XodusUtils;
import com.hivemq.persistence.local.xodus.bucket.Bucket;
import com.hivemq.persistence.payload.PublishPayloadLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadXodusSerializer;
import com.hivemq.util.LocalPersistenceFileUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class PublishPayloadXodusLocalPersistence
extends XodusLocalPersistence
implements PublishPayloadLocalPersistence {
    private static final Logger log = LoggerFactory.getLogger(PublishPayloadXodusLocalPersistence.class);
    public static final String PERSISTENCE_VERSION = "040500";
    private static final int CHUNK_SIZE = 0x500000;

    @Inject
    public PublishPayloadXodusLocalPersistence(@NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull EnvironmentUtil environmentUtil, @NotNull PersistenceStartup persistenceStartup) {
        super(environmentUtil, localPersistenceFileUtil, persistenceStartup, InternalConfigurations.PAYLOAD_PERSISTENCE_BUCKET_COUNT.get(), InternalConfigurations.PAYLOAD_PERSISTENCE_TYPE.get() == PersistenceType.FILE);
    }

    @Override
    @NotNull
    protected String getName() {
        return "publish_payload_store";
    }

    @Override
    @NotNull
    protected String getVersion() {
        return PERSISTENCE_VERSION;
    }

    @Override
    @NotNull
    protected StoreConfig getStoreConfig() {
        return StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return log;
    }

    @Override
    @PostConstruct
    protected void postConstruct() {
        super.postConstruct();
    }

    @Override
    public void init() {
        try {
            AtomicLong maxId = new AtomicLong(0L);
            for (Bucket bucket : this.buckets) {
                bucket.getEnvironment().executeInReadonlyTransaction(txn -> {
                    try (Cursor cursor = bucket.getStore().openCursor(txn);){
                        while (cursor.getNext()) {
                            KeyPair keypair = PublishPayloadXodusSerializer.deserializeKey(XodusUtils.byteIterableToBytes(cursor.getKey()));
                            if (keypair.getId() <= maxId.get()) continue;
                            maxId.set(keypair.getId());
                        }
                    }
                });
            }
            PUBLISH.PUBLISH_COUNTER.set(maxId.get() + 1L);
        }
        catch (ExodusException e) {
            log.error("An error occurred while preparing the Publish Payload persistence.");
            log.debug("Original Exception:", (Throwable)e);
            throw new UnrecoverableException(false);
        }
    }

    @Override
    public void put(long id, byte @NotNull [] payload) {
        Bucket bucket = this.getBucket(Long.toString(id));
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            int chunkIndex = 0;
            do {
                ByteIterable key = XodusUtils.bytesToByteIterable(PublishPayloadXodusSerializer.serializeKey(id, chunkIndex));
                if (payload.length < 0x500000) {
                    bucket.getStore().put(txn, key, XodusUtils.bytesToByteIterable(payload));
                    continue;
                }
                int currentChunkSize = payload.length - chunkIndex * 0x500000;
                if (currentChunkSize >= 0x500000) {
                    currentChunkSize = 0x500000;
                }
                byte[] chunk = new byte[currentChunkSize];
                System.arraycopy(payload, chunkIndex * 0x500000, chunk, 0, currentChunkSize);
                bucket.getStore().put(txn, key, XodusUtils.bytesToByteIterable(chunk));
            } while (payload.length > ++chunkIndex * 0x500000);
        });
    }

    @Override
    public byte @Nullable [] get(long id) {
        Bucket bucket = this.getBucket(Long.toString(id));
        return (byte[])bucket.getEnvironment().computeInReadonlyTransaction(transaction -> {
            HashMap<Long, byte[]> chunks = new HashMap<Long, byte[]>();
            try (Cursor cursor = bucket.getStore().openCursor(transaction);){
                int chunkIndex = 0;
                ByteIterable entry = cursor.getSearchKey(XodusUtils.bytesToByteIterable(PublishPayloadXodusSerializer.serializeKey(id, chunkIndex)));
                while (entry != null) {
                    KeyPair key = PublishPayloadXodusSerializer.deserializeKey(XodusUtils.byteIterableToBytes(cursor.getKey()));
                    chunks.put(key.getChunkIndex(), XodusUtils.byteIterableToBytes(cursor.getValue()));
                    entry = cursor.getSearchKey(XodusUtils.bytesToByteIterable(PublishPayloadXodusSerializer.serializeKey(id, ++chunkIndex)));
                }
            }
            if (chunks.isEmpty()) {
                return null;
            }
            if (chunks.size() == 1) {
                return (byte[])chunks.values().iterator().next();
            }
            int resultSize = 0;
            for (byte[] bytes : chunks.values()) {
                resultSize += bytes.length;
            }
            byte[] result = new byte[resultSize];
            for (Map.Entry entry : chunks.entrySet()) {
                System.arraycopy(entry.getValue(), 0, result, (int)((Long)entry.getKey() * 0x500000L), ((byte[])entry.getValue()).length);
            }
            return result;
        });
    }

    @Override
    @NotNull
    public ImmutableList<Long> getAllIds() {
        ImmutableList.Builder payloadIdsBuilder = ImmutableList.builder();
        for (Bucket bucket : this.buckets) {
            bucket.getEnvironment().computeInReadonlyTransaction(txn -> {
                try (Cursor cursor = bucket.getStore().openCursor(txn);){
                    while (cursor.getNext()) {
                        KeyPair key = PublishPayloadXodusSerializer.deserializeKey(XodusUtils.byteIterableToBytes(cursor.getKey()));
                        payloadIdsBuilder.add((Object)key.getId());
                    }
                }
                return null;
            });
        }
        return payloadIdsBuilder.build();
    }

    @Override
    public void remove(long id) {
        if (this.stopped.get()) {
            return;
        }
        Bucket bucket = this.getBucket(Long.toString(id));
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            boolean deleted;
            int chunkIndex = 0;
            while (deleted = bucket.getStore().delete(txn, XodusUtils.bytesToByteIterable(PublishPayloadXodusSerializer.serializeKey(id, chunkIndex++)))) {
            }
        });
    }

    @Override
    public void iterate(@NotNull PublishPayloadLocalPersistence.Callback callback) {
        ImmutableList<Long> ids = this.getAllIds();
        for (Long id : ids) {
            byte[] bytes = this.get(id);
            callback.call(id, bytes);
        }
    }

    public static class KeyPair {
        private final long id;
        private final long chunkIndex;

        KeyPair(long id, long chunkIndex) {
            this.id = id;
            this.chunkIndex = chunkIndex;
        }

        long getChunkIndex() {
            return this.chunkIndex;
        }

        public long getId() {
            return this.id;
        }
    }
}

