/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.statistics.collectors;

import com.google.common.annotations.VisibleForTesting;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.sun.jna.Platform;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerEnvironment {
    private static final Logger log = LoggerFactory.getLogger(ContainerEnvironment.class);

    public String getContainerEnvironment() {
        try {
            String content;
            if (!Platform.isLinux()) {
                return null;
            }
            File cgroupFile = this.getCgroupFile();
            if (cgroupFile.exists() && cgroupFile.canRead() && (content = FileUtils.readFileToString((File)cgroupFile, (Charset)StandardCharsets.UTF_8)).contains("docker")) {
                return "Docker";
            }
        }
        catch (Exception ex) {
            log.trace("not able to determine if running in container", (Throwable)ex);
        }
        return null;
    }

    @NotNull
    @VisibleForTesting
    File getCgroupFile() {
        long pid = ProcessHandle.current().pid();
        return new File("/proc/" + pid + "/cgroup");
    }
}

