/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checkpoints {
    private static final Logger log = LoggerFactory.getLogger(Checkpoints.class);
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private static final ConcurrentHashMap<String, Integer> checkpointCounters = new ConcurrentHashMap(1);
    private static final ConcurrentHashMap<String, CountDownLatch> checkpointLatches = new ConcurrentHashMap(1);
    private static final ConcurrentHashMap<String, Runnable> checkPointCallbacks = new ConcurrentHashMap(1);
    private static boolean enabled;
    private static boolean debug;

    public static boolean enabled() {
        return enabled;
    }

    public static void enable() {
        enabled = true;
    }

    public static void disable() {
        enabled = false;
    }

    public static void debug() {
        debug = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkpoint(@NotNull String name) {
        if (!enabled) {
            return;
        }
        CountDownLatch latch = null;
        Runnable callback = null;
        Lock lock = readWriteLock.writeLock();
        lock.lock();
        try {
            Integer previousValue;
            if (debug) {
                log.error("Checkpoint {} visited", (Object)name);
            }
            if ((previousValue = checkpointCounters.putIfAbsent(name, 1)) != null) {
                checkpointCounters.put(name, previousValue + 1);
            }
            latch = checkpointLatches.get(name);
            callback = checkPointCallbacks.get(name);
        }
        finally {
            lock.unlock();
        }
        if (callback != null) {
            if (debug) {
                log.error("Found callback for checkpoint {}", (Object)name);
            }
            try {
                callback.run();
            }
            catch (Throwable t) {
                log.error("ERROR at checkpoint callback", t);
            }
        }
        if (latch != null) {
            if (debug) {
                log.error("Found block latch for {}, blocking execution until latch is resumed", (Object)name);
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                log.error("Checkpoint block interrupted", (Throwable)e);
            }
        }
    }

    public static void resetAndWait(@NotNull String name) {
        Checkpoints.reset(name);
        Checkpoints.waitForCheckpoint(name);
    }

    public static void waitForCheckpoint(@NotNull String name) {
        Checkpoints.waitForCheckpoint(name, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForCheckpoint(@NotNull String name, int numberOfOccurrences) {
        if (!enabled) {
            return;
        }
        if (debug) {
            log.error("Waiting for checkpoint {} to be visited {} times...", (Object)name, (Object)numberOfOccurrences);
        }
        while (true) {
            Lock lock = readWriteLock.readLock();
            lock.lock();
            try {
                Integer currentValue = checkpointCounters.get(name);
                if (currentValue != null && currentValue >= numberOfOccurrences) {
                    if (debug) {
                        log.error("Checkpoint {} reached {} times, continue.", (Object)name, (Object)currentValue);
                    }
                    break;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    log.error("Wait for Checkpoint {} interrupted", (Object)name);
                    throw new RuntimeException(e);
                }
            }
            finally {
                lock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CountDownLatch blockAtCheckpoint(@NotNull String name) {
        if (!enabled) {
            return null;
        }
        Lock lock = readWriteLock.readLock();
        lock.lock();
        try {
            CountDownLatch latch = new CountDownLatch(1);
            checkpointLatches.put(name, latch);
            CountDownLatch countDownLatch = latch;
            return countDownLatch;
        }
        finally {
            lock.unlock();
        }
    }

    public static void callbackOnCheckpoint(@NotNull String name, @NotNull Runnable callback) {
        if (!enabled) {
            return;
        }
        Lock lock = readWriteLock.readLock();
        lock.lock();
        try {
            checkPointCallbacks.put(name, callback);
        }
        finally {
            lock.unlock();
        }
    }

    public static void reset() {
        Lock lock = readWriteLock.writeLock();
        lock.lock();
        try {
            if (debug) {
                log.error("checkpoint counters reset");
            }
            checkpointCounters.clear();
            checkpointLatches.clear();
            checkPointCallbacks.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public static void reset(@NotNull String name) {
        Lock lock = readWriteLock.writeLock();
        lock.lock();
        try {
            if (debug) {
                log.error("checkpoint counters reset");
            }
            checkpointCounters.remove(name);
            checkpointLatches.remove(name);
            checkPointCallbacks.remove(name);
        }
        finally {
            lock.unlock();
        }
    }
}

