/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.connectors;

import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.transport.connectors.basics.MqttQoS;

public class TransportParameter {
    private String host;
    private int port;
    private int actionTimeout = 1000;
    private String applicationId = "";
    private boolean autoApplicationId = true;
    private int keepAlive = 2000;
    private String keyAlias;
    private String keystoreKey;
    private boolean hostnameVerification = false;
    private String authenticationKey;
    private MqttQoS qos = MqttQoS.AT_LEAST_ONCE;
    private CloseAction closeAction = CloseAction.UNSUBSCRIBE;

    private TransportParameter(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getActionTimeout() {
        return this.actionTimeout;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public boolean getAutoApplicationId() {
        return this.autoApplicationId;
    }

    public String getKeystoreKey() {
        return this.keystoreKey;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getAuthenticationKey() {
        return this.authenticationKey;
    }

    public boolean getHostnameVerification() {
        return this.hostnameVerification;
    }

    public MqttQoS getMqttQoS() {
        return this.qos;
    }

    public CloseAction getCloseAction() {
        return this.closeAction;
    }

    public static enum CloseAction {
        NONE,
        UNSUBSCRIBE,
        DELETE;


        public boolean doClose() {
            return NONE != this;
        }

        public boolean doDelete() {
            return DELETE == this;
        }
    }

    public static class TransportParameterBuilder {
        private TransportParameter instance;

        private TransportParameterBuilder() {
        }

        public static TransportParameterBuilder newBuilder(String host, int port) {
            TransportParameterBuilder builder = new TransportParameterBuilder();
            builder.instance = new TransportParameter(host, port);
            return builder;
        }

        public static TransportParameterBuilder newBuilder(ServerAddress addr) {
            return TransportParameterBuilder.newBuilder(addr.getHost(), addr.getPort());
        }

        public static TransportParameterBuilder newBuilder(TransportParameter params) {
            TransportParameterBuilder builder = new TransportParameterBuilder();
            builder.instance = new TransportParameter(params.host, params.port);
            builder.instance.actionTimeout = params.actionTimeout;
            builder.instance.applicationId = params.applicationId;
            builder.instance.autoApplicationId = params.autoApplicationId;
            builder.instance.authenticationKey = params.authenticationKey;
            builder.instance.keepAlive = params.keepAlive;
            builder.instance.keyAlias = params.keyAlias;
            builder.instance.keystoreKey = params.keystoreKey;
            builder.instance.hostnameVerification = params.hostnameVerification;
            builder.instance.authenticationKey = params.authenticationKey;
            builder.instance.qos = params.qos;
            builder.instance.closeAction = params.closeAction;
            return builder;
        }

        public TransportParameterBuilder setApplicationId(String applicationId) {
            this.instance.applicationId = applicationId;
            return this;
        }

        public TransportParameterBuilder setAutoApplicationId(boolean autoApplicationId) {
            this.instance.autoApplicationId = autoApplicationId;
            return this;
        }

        public TransportParameterBuilder setKeepAlive(int keepAlive) {
            this.instance.keepAlive = keepAlive;
            return this;
        }

        public TransportParameterBuilder setActionTimeout(int actionTimeout) {
            this.instance.actionTimeout = actionTimeout;
            return this;
        }

        public TransportParameterBuilder setKeystoreKey(String keystoreKey) {
            this.instance.keystoreKey = keystoreKey;
            return this;
        }

        public TransportParameterBuilder setKeyAlias(String alias) {
            this.instance.keyAlias = alias;
            return this;
        }

        public TransportParameterBuilder setAuthenticationKey(String authenticationKey) {
            this.instance.authenticationKey = authenticationKey;
            return this;
        }

        public TransportParameterBuilder setHostnameVerification(boolean hostnameVerification) {
            this.instance.hostnameVerification = hostnameVerification;
            return this;
        }

        public TransportParameterBuilder setMqttQoS(MqttQoS qos) {
            if (null != qos) {
                this.instance.qos = qos;
            }
            return this;
        }

        public TransportParameterBuilder setCloseAction(CloseAction action) {
            if (null != action) {
                this.instance.closeAction = action;
            }
            return this;
        }

        public TransportParameter build() {
            return this.instance;
        }
    }
}

