/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.status;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.serialization.GenericJsonToStringTranslator;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import de.iip_ecosphere.platform.transport.status.TraceRecord;
import de.iip_ecosphere.platform.transport.status.TraceRecordFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class TraceRecordSerializer
implements Serializer<TraceRecord> {
    private static Set<Object> ignore = new HashSet<Object>();
    private static TraceRecordFilter filter = new TraceRecordFilter(){};

    public static TraceRecordFilter getFilter() {
        return filter;
    }

    private static ObjectMapper createMapper() {
        return JsonUtils.configureLazy((ObjectMapper)new ObjectMapper(), ignore);
    }

    public static TypeTranslator<TraceRecord, String> createTypeTranslator() {
        return new GenericJsonToStringTranslator<TraceRecord>(TraceRecord.class, TraceRecordSerializer.createMapper());
    }

    @Override
    public TraceRecord from(byte[] data) throws IOException {
        return (TraceRecord)TraceRecordSerializer.createMapper().readValue(data, TraceRecord.class);
    }

    @Override
    public byte[] to(TraceRecord source) throws IOException {
        source.setPayload(filter.filterPayload(source.getPayload()));
        return TraceRecordSerializer.createMapper().writeValueAsBytes((Object)source);
    }

    @Override
    public TraceRecord clone(TraceRecord origin) throws IOException {
        return new TraceRecord(origin.getSource(), origin.getTimestamp(), origin.getAction(), origin.getPayload());
    }

    @Override
    public Class<TraceRecord> getType() {
        return TraceRecord.class;
    }

    public static void ignoreClass(Class<?> cls) {
        ignore.add(cls);
    }

    public static void ignoreField(Class<?> cls, String field) {
        try {
            Field f = cls.getDeclaredField(field);
            ignore.add(f);
        }
        catch (NoSuchFieldException e) {
            LoggerFactory.getLogger(TraceRecordSerializer.class).warn("Field {} not found on class {}", (Object)field, (Object)cls.getName());
        }
    }

    public static void ignoreFields(Class<?> cls, String ... fields) {
        for (String field : fields) {
            TraceRecordSerializer.ignoreField(cls, field);
        }
    }

    public static void clearIgnores() {
        ignore.clear();
    }

    static {
        Optional opt = ServiceLoaderUtils.findFirst(TraceRecordFilter.class);
        if (opt.isPresent()) {
            filter = (TraceRecordFilter)opt.get();
            LoggerFactory.getLogger(TraceRecordSerializer.class).info("Installed trace record filter {}. Initializing...", (Object)filter.getClass().getName());
            filter.initialize();
        }
    }
}

