/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.config;

import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import org.apache.qpid.server.security.group.GroupPrincipal;
import org.apache.qpid.server.security.limit.ConnectionLimitException;
import org.apache.qpid.server.security.limit.ConnectionLimiter;
import org.apache.qpid.server.security.limit.ConnectionSlot;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.user.connection.limits.config.CombinableLimit;
import org.apache.qpid.server.user.connection.limits.config.ConnectionCountLimit;
import org.apache.qpid.server.user.connection.limits.config.ConnectionLimits;
import org.apache.qpid.server.user.connection.limits.config.Rule;
import org.apache.qpid.server.user.connection.limits.config.RulePredicates;
import org.apache.qpid.server.user.connection.limits.outcome.AcceptRegistration;
import org.apache.qpid.server.user.connection.limits.outcome.RejectRegistration;

final class PortConnectionCounter {
    private final Function<String, ConnectionCounter> _connectionCounterFactory;
    private final Map<String, ConnectionCounter> _connectionCounters = new ConcurrentHashMap<String, ConnectionCounter>();

    PortConnectionCounter(AbstractBuilder<?> builder) {
        this._connectionCounterFactory = builder.getConnectionCounterFactory();
    }

    public AcceptRegistration register(AMQPConnection<?> connection, ConnectionLimiter subLimiter) {
        Principal principal = connection.getAuthorizedPrincipal();
        if (principal == null) {
            throw new ConnectionLimitException("Unauthorized connection is forbidden");
        }
        String userId = principal.getName();
        return this._connectionCounters.computeIfAbsent(userId, this._connectionCounterFactory).registerConnection(userId, this.collectGroupPrincipals(connection.getSubject()), connection, subLimiter);
    }

    private Set<String> collectGroupPrincipals(Subject subject) {
        if (subject == null) {
            return Collections.emptySet();
        }
        HashSet<String> principalNames = new HashSet<String>();
        for (Principal principal : subject.getPrincipals(GroupPrincipal.class)) {
            principalNames.add(principal.getName());
        }
        return principalNames;
    }

    static Builder newBuilder(Duration defaultFrequencyPeriod) {
        if (defaultFrequencyPeriod == null || defaultFrequencyPeriod.isNegative()) {
            return new BuilderWithoutFrequencyImpl();
        }
        return new BuilderImpl();
    }

    private static final class FrequencyPeriod
    implements Comparable<FrequencyPeriod> {
        private final Instant _startTime;
        private final Duration _duration;
        private final int _limit;

        FrequencyPeriod(Instant now, Map.Entry<Duration, Integer> limit) {
            this._startTime = now.minus(limit.getKey());
            this._duration = limit.getKey();
            this._limit = limit.getValue();
        }

        @Override
        public int compareTo(FrequencyPeriod o) {
            return this._startTime.compareTo(o._startTime);
        }

        public int hashCode() {
            return this._startTime.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof FrequencyPeriod) {
                return this._startTime.equals(((FrequencyPeriod)o)._startTime);
            }
            return false;
        }

        boolean isPeriodBeginningBefore(Instant time) {
            return this._startTime.isBefore(time);
        }

        boolean isCounterUnderLimit(int counter) {
            return counter < this._limit;
        }

        Duration getDuration() {
            return this._duration;
        }

        int getLimit() {
            return this._limit;
        }
    }

    private static final class LimitCompiler<T extends CombinableLimit<T>> {
        private final Map<String, T> _limitMap;
        private final T _defaultLimits;
        private final Supplier<T> _noLimits;

        LimitCompiler(Map<String, T> limitMap, T defaultLimits, Supplier<T> noLimits) {
            this._limitMap = new HashMap<String, T>(limitMap);
            this._defaultLimits = (CombinableLimit)Objects.requireNonNull(defaultLimits);
            this._noLimits = Objects.requireNonNull(noLimits);
        }

        public T compileLimits(String userId, Set<String> groups) {
            CombinableLimit userLimits = ((CombinableLimit)this._noLimits.get()).mergeWith((CombinableLimit)this._limitMap.get(userId));
            CombinableLimit groupLimits = (CombinableLimit)this._noLimits.get();
            for (String group : groups) {
                groupLimits = groupLimits.mergeWith((CombinableLimit)this._limitMap.get(group));
            }
            return userLimits.then(groupLimits).then(this._defaultLimits);
        }
    }

    private static final class ConnectionCounterImpl
    implements ConnectionCounter {
        private final LimitCompiler<ConnectionCountLimit> _limits;
        private long _counter = 0L;

        ConnectionCounterImpl(LimitCompiler<ConnectionCountLimit> limits) {
            this._limits = limits;
        }

        public synchronized void free() {
            this._counter = Math.max(this._counter - 1L, 0L);
        }

        @Override
        public AcceptRegistration registerConnection(String userId, Set<String> groups, AMQPConnection<?> connection, ConnectionLimiter subLimiter) {
            ConnectionCountLimit limits = this._limits.compileLimits(userId, groups);
            if (limits.isUserBlocked()) {
                throw RejectRegistration.blockedUser(userId, connection.getPort().getName());
            }
            if (limits.getCountLimit() == null) {
                return this.noLimits(userId, connection, subLimiter);
            }
            return this.countLimit(limits.getCountLimit(), userId, connection, subLimiter);
        }

        private synchronized AcceptRegistration noLimits(String id, AMQPConnection<?> connection, ConnectionLimiter subLimiter) {
            AcceptRegistration result = AcceptRegistration.newInstance(this.chainTo(subLimiter.register(connection)), id, this._counter + 1L, connection.getPort().getName());
            ++this._counter;
            return result;
        }

        private synchronized AcceptRegistration countLimit(Integer countLimit, String id, AMQPConnection<?> connection, ConnectionLimiter subLimiter) {
            if (this._counter >= (long)countLimit.intValue()) {
                throw RejectRegistration.breakingConnectionCount(id, countLimit, connection.getPort().getName());
            }
            AcceptRegistration result = AcceptRegistration.newInstance(this.chainTo(subLimiter.register(connection)), id, this._counter + 1L, connection.getPort().getName());
            ++this._counter;
            return result;
        }
    }

    private static final class CombinedConnectionCounterImpl
    implements ConnectionCounter {
        private final LimitCompiler<ConnectionLimits> _limits;
        private final Queue<Instant> _registrationTime = new LinkedList<Instant>();
        private long _counter = 0L;

        CombinedConnectionCounterImpl(LimitCompiler<ConnectionLimits> limits) {
            this._limits = limits;
        }

        public synchronized void free() {
            this._counter = Math.max(this._counter - 1L, 0L);
        }

        @Override
        public AcceptRegistration registerConnection(String userId, Set<String> groups, AMQPConnection<?> connection, ConnectionLimiter subLimiter) {
            ConnectionLimits limits = this._limits.compileLimits(userId, groups);
            if (limits.isUserBlocked()) {
                throw RejectRegistration.blockedUser(userId, connection.getPort().getName());
            }
            Integer connectionCountLimit = limits.getCountLimit();
            Map<Duration, Integer> connectionFrequencyLimit = limits.getFrequencyLimits();
            if (connectionFrequencyLimit.isEmpty()) {
                if (connectionCountLimit == null) {
                    return this.noLimits(userId, connection, subLimiter);
                }
                return this.countLimit(connectionCountLimit, userId, connection, subLimiter);
            }
            if (connectionCountLimit == null) {
                return this.frequencyLimit(connectionFrequencyLimit, userId, connection, subLimiter);
            }
            return this.bothLimits(connectionCountLimit, connectionFrequencyLimit, userId, connection, subLimiter);
        }

        private synchronized AcceptRegistration noLimits(String id, AMQPConnection<?> connection, ConnectionLimiter subLimiter) {
            this._registrationTime.clear();
            AcceptRegistration result = AcceptRegistration.newInstance(this.chainTo(subLimiter.register(connection)), id, this._counter + 1L, connection.getPort().getName());
            ++this._counter;
            return result;
        }

        private synchronized AcceptRegistration countLimit(Integer countLimit, String id, AMQPConnection<?> connection, ConnectionLimiter subLimiter) {
            this._registrationTime.clear();
            this.checkCounter(countLimit, id, connection);
            AcceptRegistration result = AcceptRegistration.newInstance(this.chainTo(subLimiter.register(connection)), id, this._counter + 1L, connection.getPort().getName());
            ++this._counter;
            return result;
        }

        private synchronized AcceptRegistration frequencyLimit(Map<Duration, Integer> frequencyLimit, String id, AMQPConnection<?> connection, ConnectionLimiter subLimiter) {
            Instant now = this.checkFrequencyLimit(frequencyLimit, id, connection);
            AcceptRegistration result = AcceptRegistration.newInstance(this.chainTo(subLimiter.register(connection)), id, this._counter + 1L, connection.getPort().getName());
            this._registrationTime.add(now);
            ++this._counter;
            return result;
        }

        private synchronized AcceptRegistration bothLimits(Integer countLimit, Map<Duration, Integer> frequencyLimit, String id, AMQPConnection<?> connection, ConnectionLimiter subLimiter) {
            Instant now = this.checkFrequencyLimit(frequencyLimit, id, connection);
            this.checkCounter(countLimit, id, connection);
            AcceptRegistration result = AcceptRegistration.newInstance(this.chainTo(subLimiter.register(connection)), id, this._counter + 1L, connection.getPort().getName());
            this._registrationTime.add(now);
            ++this._counter;
            return result;
        }

        private void checkCounter(Integer countLimit, String id, AMQPConnection<?> connection) {
            if (this._counter >= (long)countLimit.intValue()) {
                throw RejectRegistration.breakingConnectionCount(id, countLimit, connection.getPort().getName());
            }
        }

        private Instant checkFrequencyLimit(Map<Duration, Integer> frequencyLimit, String id, AMQPConnection<?> connection) {
            Instant now = Instant.now();
            TreeSet<FrequencyPeriod> periods = new TreeSet<FrequencyPeriod>();
            for (Map.Entry<Duration, Integer> entry : frequencyLimit.entrySet()) {
                periods.add(new FrequencyPeriod(now, entry));
            }
            Iterator registrationTimeIterator = this._registrationTime.iterator();
            int counter = this._registrationTime.size();
            boolean obsoleteRegistrationTime = true;
            while (registrationTimeIterator.hasNext() && !periods.isEmpty()) {
                FrequencyPeriod period;
                Instant registrationTime = (Instant)registrationTimeIterator.next();
                Iterator periodIterator = periods.iterator();
                while (periodIterator.hasNext() && (period = (FrequencyPeriod)periodIterator.next()).isPeriodBeginningBefore(registrationTime)) {
                    if (!period.isCounterUnderLimit(counter)) {
                        throw RejectRegistration.breakingConnectionFrequency(id, period.getLimit(), period.getDuration(), connection.getPort().getName());
                    }
                    obsoleteRegistrationTime = false;
                    periodIterator.remove();
                }
                --counter;
                if (!obsoleteRegistrationTime) continue;
                registrationTimeIterator.remove();
            }
            return now;
        }
    }

    private static final class BuilderWithoutFrequencyImpl
    extends AbstractBuilder<ConnectionCountLimit> {
        BuilderWithoutFrequencyImpl() {
            super(ConnectionCountLimit.noLimits());
        }

        @Override
        ConnectionCountLimit newLimits(Rule rule) {
            return ConnectionCountLimit.newInstance(rule);
        }

        @Override
        Function<String, ConnectionCounter> getConnectionCounterFactory() {
            return userId -> new ConnectionCounterImpl(new LimitCompiler<ConnectionCountLimit>(this._userLimits, (ConnectionCountLimit)this._defaultUserLimits, ConnectionCountLimit::noLimits));
        }
    }

    private static final class BuilderImpl
    extends AbstractBuilder<ConnectionLimits> {
        BuilderImpl() {
            super(ConnectionLimits.noLimits());
        }

        @Override
        ConnectionLimits newLimits(Rule rule) {
            if (rule.getFrequencyLimit() != null && (rule.getFrequencyPeriod() == null || rule.getFrequencyPeriod().isNegative())) {
                throw new IllegalArgumentException("Connection frequency limit needs a time period");
            }
            return rule;
        }

        @Override
        Function<String, ConnectionCounter> getConnectionCounterFactory() {
            return userId -> new CombinedConnectionCounterImpl(new LimitCompiler<ConnectionLimits>(this._userLimits, (ConnectionLimits)this._defaultUserLimits, ConnectionLimits::noLimits));
        }
    }

    static abstract class AbstractBuilder<T extends CombinableLimit<T>>
    implements Builder {
        final Map<String, T> _userLimits = new HashMap<String, T>();
        T _defaultUserLimits;

        abstract T newLimits(Rule var1);

        abstract Function<String, ConnectionCounter> getConnectionCounterFactory();

        AbstractBuilder(T defaultUserLimits) {
            this._defaultUserLimits = defaultUserLimits;
        }

        @Override
        public Builder add(Rule rule) {
            this.addImpl(rule);
            return this;
        }

        @Override
        public Builder addAll(Collection<? extends Rule> rule) {
            if (rule != null) {
                rule.forEach(this::addImpl);
            }
            return this;
        }

        @Override
        public PortConnectionCounter build() {
            return new PortConnectionCounter(this);
        }

        private void addImpl(Rule rule) {
            if (rule == null) {
                return;
            }
            T newLimits = this.newLimits(rule);
            if (newLimits.isEmpty()) {
                return;
            }
            String id = rule.getIdentity();
            if (RulePredicates.isAllUser(id)) {
                this._defaultUserLimits = newLimits.mergeWith(this._defaultUserLimits);
            } else {
                this._userLimits.merge(id, newLimits, CombinableLimit::mergeWith);
            }
        }
    }

    private static interface ConnectionCounter
    extends ConnectionSlot {
        public AcceptRegistration registerConnection(String var1, Set<String> var2, AMQPConnection<?> var3, ConnectionLimiter var4);
    }

    public static interface Builder {
        public Builder add(Rule var1);

        public Builder addAll(Collection<? extends Rule> var1);

        public PortConnectionCounter build();
    }
}

