/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import java.io.File;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.io.FileDataReader;
import jetbrains.exodus.io.FileDataWriter;
import jetbrains.exodus.log.LogUtil;
import org.jetbrains.annotations.NotNull;

public class LogConfig {
    private static final int DEFAULT_FILE_SIZE = 1024;
    private File dir;
    private long fileSize;
    private long lockTimeout;
    private String lockId;
    private long memoryUsage;
    private int memoryUsagePercentage;
    private DataReader reader;
    private DataWriter writer;
    private boolean isDurableWrite;
    private boolean isFsyncSuppressed;
    private boolean sharedCache;
    private boolean nonBlockingCache;
    private int cachePageSize;
    private int cacheOpenFilesCount;
    private boolean cacheUseNio;
    private long cacheFreePhysicalMemoryThreshold;
    private boolean cleanDirectoryExpected;
    private boolean clearInvalidLog;
    private long syncPeriod;
    private boolean fullFileReadonly;
    private StreamCipherProvider cipherProvider;
    private byte[] cipherKey;
    private long cipherBasicIV;

    public LogConfig setDir(@NotNull File dir) {
        this.dir = dir;
        return this;
    }

    public long getFileSize() {
        if (this.fileSize == 0L) {
            this.fileSize = 1024L;
        }
        return this.fileSize;
    }

    public LogConfig setFileSize(long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public LogConfig setLockTimeout(long lockTimeout) {
        this.lockTimeout = lockTimeout;
        return this;
    }

    public String getLockId() {
        return this.lockId;
    }

    public LogConfig setLockId(String lockId) {
        this.lockId = lockId;
        return this;
    }

    public long getMemoryUsage() {
        return this.memoryUsage;
    }

    public LogConfig setMemoryUsage(long memUsage) {
        this.memoryUsage = memUsage;
        return this;
    }

    public int getMemoryUsagePercentage() {
        if (this.memoryUsagePercentage == 0) {
            this.memoryUsagePercentage = 50;
        }
        return this.memoryUsagePercentage;
    }

    public LogConfig setMemoryUsagePercentage(int memoryUsagePercentage) {
        this.memoryUsagePercentage = memoryUsagePercentage;
        return this;
    }

    public DataReader getReader() {
        if (this.reader == null) {
            this.reader = new FileDataReader(this.checkDirectory(this.dir), this.getCacheOpenFilesCount(), this.getCacheUseNio(), this.getCacheFreePhysicalMemoryThreshold());
        }
        return this.reader;
    }

    public LogConfig setReader(@NotNull DataReader reader) {
        this.reader = reader;
        return this;
    }

    public DataWriter getWriter() {
        if (this.writer == null) {
            this.writer = new FileDataWriter(this.checkDirectory(this.dir), this.getLockId());
        }
        return this.writer;
    }

    public LogConfig setWriter(@NotNull DataWriter writer) {
        this.writer = writer;
        return this;
    }

    public boolean isDurableWrite() {
        return this.isDurableWrite;
    }

    public LogConfig setDurableWrite(boolean durableWrite) {
        this.isDurableWrite = durableWrite;
        return this;
    }

    public boolean isFsyncSuppressed() {
        return this.isFsyncSuppressed;
    }

    public LogConfig setFsyncSuppressed(boolean fsyncSuppressed) {
        this.isFsyncSuppressed = fsyncSuppressed;
        return this;
    }

    public boolean isSharedCache() {
        return this.sharedCache;
    }

    public LogConfig setSharedCache(boolean sharedCache) {
        this.sharedCache = sharedCache;
        return this;
    }

    public boolean isNonBlockingCache() {
        return this.nonBlockingCache;
    }

    public LogConfig setNonBlockingCache(boolean nonBlockingCache) {
        this.nonBlockingCache = nonBlockingCache;
        return this;
    }

    public int getCachePageSize() {
        if (this.cachePageSize == 0) {
            this.cachePageSize = 1024;
        }
        return this.cachePageSize;
    }

    public LogConfig setCachePageSize(int cachePageSize) {
        this.cachePageSize = cachePageSize;
        return this;
    }

    public int getCacheOpenFilesCount() {
        if (this.cacheOpenFilesCount == 0) {
            this.cacheOpenFilesCount = 16;
        }
        return this.cacheOpenFilesCount;
    }

    public LogConfig setCacheOpenFilesCount(int cacheOpenFilesCount) {
        this.cacheOpenFilesCount = cacheOpenFilesCount;
        return this;
    }

    public boolean getCacheUseNio() {
        return this.cacheUseNio;
    }

    public LogConfig setCacheUseNio(boolean cacheUseNio) {
        this.cacheUseNio = cacheUseNio;
        return this;
    }

    public long getCacheFreePhysicalMemoryThreshold() {
        if (this.cacheFreePhysicalMemoryThreshold == 0L) {
            this.cacheFreePhysicalMemoryThreshold = EnvironmentConfig.DEFAULT.getLogCacheFreePhysicalMemoryThreshold();
        }
        return this.cacheFreePhysicalMemoryThreshold;
    }

    public LogConfig setCacheFreePhysicalMemoryThreshold(long cacheFreePhysicalMemoryThreshold) {
        this.cacheFreePhysicalMemoryThreshold = cacheFreePhysicalMemoryThreshold;
        return this;
    }

    public LogConfig setCleanDirectoryExpected(boolean cleanDirectoryExpected) {
        this.cleanDirectoryExpected = cleanDirectoryExpected;
        return this;
    }

    public boolean isClearInvalidLog() {
        return this.clearInvalidLog;
    }

    public LogConfig setClearInvalidLog(boolean clearInvalidLog) {
        this.clearInvalidLog = clearInvalidLog;
        return this;
    }

    public long getSyncPeriod() {
        if (this.syncPeriod == 0L) {
            this.syncPeriod = EnvironmentConfig.DEFAULT.getLogSyncPeriod();
        }
        return this.syncPeriod;
    }

    public LogConfig setSyncPeriod(long syncPeriod) {
        this.syncPeriod = syncPeriod;
        return this;
    }

    public boolean isFullFileReadonly() {
        return this.fullFileReadonly;
    }

    public LogConfig setFullFileReadonly(boolean fullFileReadonly) {
        this.fullFileReadonly = fullFileReadonly;
        return this;
    }

    public StreamCipherProvider getCipherProvider() {
        return this.cipherProvider;
    }

    public LogConfig setCipherProvider(StreamCipherProvider cipherProvider) {
        this.cipherProvider = cipherProvider;
        return this;
    }

    public byte[] getCipherKey() {
        return this.cipherKey;
    }

    public LogConfig setCipherKey(byte[] cipherKey) {
        this.cipherKey = cipherKey;
        return this;
    }

    public long getCipherBasicIV() {
        return this.cipherBasicIV;
    }

    public LogConfig setCipherBasicIV(long basicIV) {
        this.cipherBasicIV = basicIV;
        return this;
    }

    public static LogConfig create(@NotNull DataReader reader, @NotNull DataWriter writer) {
        return new LogConfig().setReader(reader).setWriter(writer);
    }

    private File checkDirectory(@NotNull File directory) {
        if (directory.isFile()) {
            throw new ExodusException("A directory is required: " + directory);
        }
        if (directory.exists()) {
            if (this.cleanDirectoryExpected && LogUtil.listFiles(directory).length > 0) {
                throw new ExodusException("Clean directory expected (log configured to be newly created only)");
            }
        } else if (!directory.mkdirs()) {
            throw new ExodusException("Failed to create directory: " + directory);
        }
        return directory;
    }
}

