/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.util.Collection;
import java.util.Iterator;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.ExpiredLoggableInfo;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.INode;
import jetbrains.exodus.tree.ITreeCursor;
import jetbrains.exodus.tree.ITreeCursorMutable;
import jetbrains.exodus.tree.ITreeMutable;
import jetbrains.exodus.tree.MutableTreeRoot;
import jetbrains.exodus.tree.TreeCursorMutable;
import jetbrains.exodus.tree.patricia.PatriciaTreeMutable;
import jetbrains.exodus.tree.patricia.PatriciaTreeWithDuplicates;
import jetbrains.exodus.tree.patricia.UnEscapingByteIterable;
import jetbrains.exodus.util.ByteIterableUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PatriciaTreeWithDuplicatesMutable
extends PatriciaTreeWithDuplicates
implements ITreeMutable {
    PatriciaTreeWithDuplicatesMutable(@NotNull ITreeMutable treeNoDuplicates) {
        super(treeNoDuplicates);
    }

    @Override
    @NotNull
    public ITreeMutable getMutableCopy() {
        return this;
    }

    @Override
    public void cursorClosed(@NotNull ITreeCursorMutable cursor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MutableTreeRoot getRoot() {
        return this.getTreeNoDuplicates().getRoot();
    }

    @Override
    public boolean isAllowingDuplicates() {
        return true;
    }

    @Override
    @Nullable
    public Iterable<ITreeCursorMutable> getOpenCursors() {
        return this.getTreeNoDuplicates().getOpenCursors();
    }

    @Override
    public boolean put(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return this.getTreeNoDuplicates().put(PatriciaTreeWithDuplicatesMutable.getEscapedKeyValue(key, value), CompressedUnsignedLongByteIterable.getIterable(key.getLength()));
    }

    @Override
    public void putRight(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        this.getTreeNoDuplicates().putRight(PatriciaTreeWithDuplicatesMutable.getEscapedKeyValue(key, value), CompressedUnsignedLongByteIterable.getIterable(key.getLength()));
    }

    @Override
    public boolean add(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return this.getTreeNoDuplicates().add(PatriciaTreeWithDuplicatesMutable.getEscapedKeyValue(key, value), CompressedUnsignedLongByteIterable.getIterable(key.getLength()));
    }

    @Override
    public void put(@NotNull INode ln) {
        this.put(ln.getKey(), PatriciaTreeMutable.getNotNullValue(ln));
    }

    @Override
    public void putRight(@NotNull INode ln) {
        this.putRight(ln.getKey(), PatriciaTreeMutable.getNotNullValue(ln));
    }

    @Override
    public boolean add(@NotNull INode ln) {
        return this.add(ln.getKey(), PatriciaTreeMutable.getNotNullValue(ln));
    }

    @Override
    public boolean delete(@NotNull ByteIterable key) {
        boolean wasDeleted = false;
        try (ITreeCursor cursor = this.treeNoDuplicates.openCursor();){
            byte[] keyBytes = key.getBytesUnsafe();
            int keyLength = key.getLength();
            ByteIterable value = cursor.getSearchKeyRange(PatriciaTreeWithDuplicatesMutable.getEscapedKeyWithSeparator(key));
            while (value != null) {
                if (keyLength != CompressedUnsignedLongByteIterable.getInt(value)) {
                    break;
                }
                UnEscapingByteIterable noDupKey = new UnEscapingByteIterable(cursor.getKey());
                if (ByteIterableUtil.compare((byte[])keyBytes, (int)keyLength, (byte[])noDupKey.getBytesUnsafe(), (int)keyLength) != 0) {
                    break;
                }
                cursor.deleteCurrent();
                wasDeleted = true;
                value = cursor.getNext() ? cursor.getValue() : null;
            }
        }
        return wasDeleted;
    }

    @Override
    public boolean delete(@NotNull ByteIterable key, @Nullable ByteIterable value, @Nullable ITreeCursorMutable cursorToSkip) {
        if (value == null) {
            return this.delete(key);
        }
        if (this.getTreeNoDuplicates().delete(PatriciaTreeWithDuplicatesMutable.getEscapedKeyValue(key, value))) {
            TreeCursorMutable.notifyCursors(this, cursorToSkip);
            return true;
        }
        return false;
    }

    @Override
    public long save() {
        return this.getTreeNoDuplicates().save();
    }

    @Override
    @NotNull
    public Collection<ExpiredLoggableInfo> getExpiredLoggables() {
        return this.getTreeNoDuplicates().getExpiredLoggables();
    }

    @Override
    public boolean reclaim(@NotNull RandomAccessLoggable loggable, @NotNull Iterator<RandomAccessLoggable> loggables) {
        return ((ITreeMutable)this.treeNoDuplicates).reclaim(loggable, loggables);
    }

    private ITreeMutable getTreeNoDuplicates() {
        return (ITreeMutable)this.treeNoDuplicates;
    }
}

